"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PhrAppointmentStatusService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
let PhrAppointmentStatusService = class PhrAppointmentStatusService {
    constructor(dynamicConnection, connection) {
        this.dynamicConnection = dynamicConnection;
        this.connection = connection;
    }
    async findAll(appointment_id) {
        if (appointment_id) {
            const [gethosId] = await this.connection.query(`select * from appointment where id = ?`, [appointment_id]);
            try {
                const query = `select appointment_status_id from appointment_status_tracking 
         WHERE appointment_id = ? order by appointment_status_tracking.appointment_status_id DESC limit 1`;
                let getAllStatus = await this.dynamicConnection.query(`select * from appointment_status`);
                const [appointmentStatusData] = await this.dynamicConnection.query(query, [gethosId.hos_appointment_id]);
                let latestappt_status_id = appointmentStatusData.appointment_status_id;
                if (latestappt_status_id != 4) {
                    getAllStatus = getAllStatus.filter(item => item.id !== 4);
                }
                getAllStatus.forEach(obj => {
                    obj.is_completed = obj.id <= latestappt_status_id ? 1 : 0;
                });
                return getAllStatus;
            }
            catch (error) {
                return error;
            }
        }
        else {
            return {
                "status": "failed",
                "message": "Enter appointment_id to get appointment status"
            };
        }
    }
    async appointment_status_tracking(appointment_id) {
        if (appointment_id) {
            const [getHos_id] = await this.connection.query(`select * from appointment where id = ?`, [appointment_id]);
            try {
                const query = `select appointment_status.status,appointment_status.color_code,appointment_status_tracking.appointment_status_id,
        appointment_status_tracking.appointment_id,
       concat( DATE_FORMAT(date(appointment_status_tracking.date_updated), '%D %b %Y')," ",
        DATE_FORMAT(time(appointment_status_tracking.date_updated), '%h:%i %p')) date_updated
        from appointment_status_tracking
        left join appointment_status on appointment_status.id = appointment_status_tracking.appointment_status_id WHERE appointment_id = ?`;
                const appointmentStatusData = await this.dynamicConnection.query(query, [getHos_id.hos_appointment_id]);
                return appointmentStatusData;
            }
            catch (error) {
                return error;
            }
        }
        else {
            return {
                status: "failed",
                message: "Enter appointment_id to get the values"
            };
        }
    }
    async findAllForTracking(hospital_id) {
        if (hospital_id) {
            try {
                const query = `SELECT * FROM appointment_status WHERE appointment_status.id <> 4`;
                const appointmentStatusData = await this.dynamicConnection.query(query);
                return appointmentStatusData;
            }
            catch (error) {
                return error;
            }
        }
        else {
            return {
                status: "failed",
                message: "Enter hospital_id to get the values"
            };
        }
    }
};
exports.PhrAppointmentStatusService = PhrAppointmentStatusService;
exports.PhrAppointmentStatusService = PhrAppointmentStatusService = __decorate([
    (0, common_1.Injectable)(),
    __param(1, (0, typeorm_1.InjectDataSource)('AdminConnection')),
    __metadata("design:paramtypes", [typeorm_2.DataSource,
        typeorm_2.DataSource])
], PhrAppointmentStatusService);
//# sourceMappingURL=phr-appointment-status.service.js.map