"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PhpTransactionReportController = void 0;
const common_1 = require("@nestjs/common");
const php_transaction_report_service_1 = require("./php-transaction-report.service");
const create_php_transaction_report_dto_1 = require("./dto/create-php-transaction-report.dto");
const update_php_transaction_report_dto_1 = require("./dto/update-php-transaction-report.dto");
const auth_guard_1 = require("../auth/auth.guard");
let PhpTransactionReportController = class PhpTransactionReportController {
    constructor(phpTransactionReportService) {
        this.phpTransactionReportService = phpTransactionReportService;
    }
    async create(createPhpTransactionReportDto, limit, page, search, filter) {
        if (!createPhpTransactionReportDto.startDate || !createPhpTransactionReportDto.endDate) {
            return {
                status_code: process.env.ERROR_STATUS_CODE_PARAM_MISSING,
                status: process.env.ERROR_STATUS,
                message: process.env.ERROR_MESSAGE_PARAM_MISSING,
            };
        }
        try {
            const final_out = await this.phpTransactionReportService.create(createPhpTransactionReportDto, Number(limit) || 10, Number(page) || 1, search, filter);
            if (final_out?.details.length > 0) {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE_V2,
                    status: process.env.SUCCESS_STATUS_V2,
                    message: process.env.SUCCESS_MESSAGE_V2,
                    data: final_out.details,
                    total: final_out.total,
                };
            }
            else {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE_V2,
                    status: process.env.SUCCESS_STATUS_V2,
                    message: process.env.DATA_NOT_FOUND_V2,
                };
            }
        }
        catch (error) {
            console.error("Controller Error:", error);
            return {
                status_code: process.env.ERROR_STATUS_CODE_V2,
                status: process.env.ERROR_STATUS_V2,
                message: process.env.ERROR_MESSAGE_V2,
            };
        }
    }
    findAll() {
        return this.phpTransactionReportService.findAll();
    }
    update(id, updatePhpTransactionReportDto) {
        return this.phpTransactionReportService.update(+id, updatePhpTransactionReportDto);
    }
    remove(id) {
        return this.phpTransactionReportService.remove(+id);
    }
    findAllCollectedBy() {
        console.log("c");
        return this.phpTransactionReportService.findcollected_by();
    }
};
exports.PhpTransactionReportController = PhpTransactionReportController;
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Post)(),
    __param(0, (0, common_1.Body)()),
    __param(1, (0, common_1.Query)('limit')),
    __param(2, (0, common_1.Query)('page')),
    __param(3, (0, common_1.Query)('search')),
    __param(4, (0, common_1.Query)('filter')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [create_php_transaction_report_dto_1.CreatePhpTransactionReportDto, Number, Number, String, String]),
    __metadata("design:returntype", Promise)
], PhpTransactionReportController.prototype, "create", null);
__decorate([
    (0, common_1.Get)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], PhpTransactionReportController.prototype, "findAll", null);
__decorate([
    (0, common_1.Patch)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, update_php_transaction_report_dto_1.UpdatePhpTransactionReportDto]),
    __metadata("design:returntype", void 0)
], PhpTransactionReportController.prototype, "update", null);
__decorate([
    (0, common_1.Delete)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], PhpTransactionReportController.prototype, "remove", null);
__decorate([
    (0, common_1.Get)('/collected_by'),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], PhpTransactionReportController.prototype, "findAllCollectedBy", null);
exports.PhpTransactionReportController = PhpTransactionReportController = __decorate([
    (0, common_1.Controller)('php-transaction-report'),
    __metadata("design:paramtypes", [php_transaction_report_service_1.PhpTransactionReportService])
], PhpTransactionReportController);
//# sourceMappingURL=php-transaction-report.controller.js.map