"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PhpRecordsController = void 0;
const common_1 = require("@nestjs/common");
const php_records_service_1 = require("./php-records.service");
const php_record_entity_1 = require("./entities/php-record.entity");
let PhpRecordsController = class PhpRecordsController {
    constructor(phpRecordsService) {
        this.phpRecordsService = phpRecordsService;
    }
    create(createPhpRecordDto) {
        return this.phpRecordsService.createDeath(createPhpRecordDto);
    }
    createBirth(createPhpRecordDto) {
        return this.phpRecordsService.createBirth(createPhpRecordDto);
    }
    findAll() {
        return this.phpRecordsService.findAll();
    }
    findOne(id) {
        return this.phpRecordsService.findOne(+id);
    }
    updateDeath(id, updatePhpRecordDto) {
        return this.phpRecordsService.updateDeath(+id, updatePhpRecordDto);
    }
    update(id, updatePhpRecordDto) {
        return this.phpRecordsService.updateBirth(+id, updatePhpRecordDto);
    }
    remove(id, hospital_id) {
        if (!hospital_id) {
            return {
                "status": "failed",
                "message": "enter hospital_id to delete"
            };
        }
        return this.phpRecordsService.removeDeath(+id, hospital_id);
    }
    removeBirth(id, hospital_id) {
        if (!hospital_id) {
            return {
                "status": "failed",
                "message": "enter hospital_id to delete"
            };
        }
        return this.phpRecordsService.removeBirth(+id, hospital_id);
    }
};
exports.PhpRecordsController = PhpRecordsController;
__decorate([
    (0, common_1.Post)('/death'),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [php_record_entity_1.PhpDeathRecord]),
    __metadata("design:returntype", void 0)
], PhpRecordsController.prototype, "create", null);
__decorate([
    (0, common_1.Post)('/birth'),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [php_record_entity_1.PhpBirthRecord]),
    __metadata("design:returntype", void 0)
], PhpRecordsController.prototype, "createBirth", null);
__decorate([
    (0, common_1.Get)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], PhpRecordsController.prototype, "findAll", null);
__decorate([
    (0, common_1.Get)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], PhpRecordsController.prototype, "findOne", null);
__decorate([
    (0, common_1.Patch)('/death/:id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, php_record_entity_1.PhpDeathRecord]),
    __metadata("design:returntype", void 0)
], PhpRecordsController.prototype, "updateDeath", null);
__decorate([
    (0, common_1.Patch)('/birth/:id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, php_record_entity_1.PhpBirthRecord]),
    __metadata("design:returntype", void 0)
], PhpRecordsController.prototype, "update", null);
__decorate([
    (0, common_1.Delete)('/death/:id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Body)('hospital_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Object]),
    __metadata("design:returntype", void 0)
], PhpRecordsController.prototype, "remove", null);
__decorate([
    (0, common_1.Delete)('/birth/:id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Body)('hospital_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Object]),
    __metadata("design:returntype", void 0)
], PhpRecordsController.prototype, "removeBirth", null);
exports.PhpRecordsController = PhpRecordsController = __decorate([
    (0, common_1.Controller)('php-records'),
    __metadata("design:paramtypes", [php_records_service_1.PhpRecordsService])
], PhpRecordsController);
//# sourceMappingURL=php-records.controller.js.map