"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PhpPayrollReportService = void 0;
const common_1 = require("@nestjs/common");
const event_emitter_1 = require("@nestjs/event-emitter");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
let PhpPayrollReportService = class PhpPayrollReportService {
    constructor(connection, dynamicConnection, eventEmitter) {
        this.connection = connection;
        this.dynamicConnection = dynamicConnection;
        this.eventEmitter = eventEmitter;
    }
    async create(createPhpAppointmentReportDto, limit, page, search) {
        const offset = limit * (page - 1);
        let query = `
      SELECT 
    staff.id AS staff_id,
    staff.employee_id,
    staff.name,
    roles.name AS user_type,
    staff.surname,
    staff_designation.designation,
    department.department_name AS department,
    staff_payslip.*
FROM 
    staff
INNER JOIN 
    staff_payslip ON staff_payslip.staff_id = staff.id
LEFT JOIN 
    staff_designation ON staff.staff_designation_id = staff_designation.id
LEFT JOIN 
    department ON staff.department_id = department.id
LEFT JOIN 
    staff_roles ON staff_roles.staff_id = staff.id
LEFT JOIN 
    roles ON staff_roles.role_id = roles.id
WHERE 
    staff_payslip.status = 'paid'
    

    `;
        let countQuery = `
      SELECT COUNT(staff.id) AS total 
      FROM 
    staff
INNER JOIN 
    staff_payslip ON staff_payslip.staff_id = staff.id
LEFT JOIN 
    staff_designation ON staff.staff_designation_id = staff_designation.id
LEFT JOIN 
    department ON staff.department_id = department.id
LEFT JOIN 
    staff_roles ON staff_roles.staff_id = staff.id
LEFT JOIN 
    roles ON staff_roles.role_id = roles.id
WHERE 
    staff_payslip.status = 'paid'

    `;
        const queryParams = [];
        if (createPhpAppointmentReportDto.month) {
            query += ` AND LOWER(staff_payslip.month) = lower(?) `;
            countQuery += ` AND LOWER(staff_payslip.month) = lower(?) `;
            queryParams.push(createPhpAppointmentReportDto.month);
        }
        if (createPhpAppointmentReportDto.year) {
            query += ` AND staff_payslip.year = ? `;
            countQuery += ` AND staff_payslip.year = ?`;
            queryParams.push(createPhpAppointmentReportDto.year);
        }
        if (createPhpAppointmentReportDto.roleId) {
            query += `  AND roles.id = ? `;
            countQuery += `  AND roles.id = ? `;
            queryParams.push(createPhpAppointmentReportDto.roleId);
        }
        if (search) {
            const likeSearch = [`%${search}%`, `%${search}%`, `%${search}%`, `%${search}%`];
            query += ` AND (roles.name LIKE ? OR staff_designation.designation LIKE ? OR staff.name LIKE ? OR staff.surname LIKE ?)`;
            countQuery += ` AND (roles.name LIKE ? OR staff_designation.designation LIKE ? OR staff.name LIKE ? OR staff.surname LIKE ?)`;
            queryParams.push(...likeSearch);
        }
        query += `  LIMIT ? OFFSET ?`;
        queryParams.push(limit, offset);
        try {
            const data = await this.connection.query(query, queryParams);
            const [countData] = await this.connection.query(countQuery, queryParams);
            return {
                details: data,
                count: countData?.total ?? 0
            };
        }
        catch (error) {
            console.error("SQL Error:", error);
            throw error;
        }
    }
    findAll() {
        return `This action returns all phpPayrollReport`;
    }
    findOne(id) {
        return `This action returns a #${id} phpPayrollReport`;
    }
    update(id, updatePhpPayrollReportDto) {
        return `This action updates a #${id} phpPayrollReport`;
    }
    remove(id) {
        return `This action removes a #${id} phpPayrollReport`;
    }
};
exports.PhpPayrollReportService = PhpPayrollReportService;
exports.PhpPayrollReportService = PhpPayrollReportService = __decorate([
    (0, common_1.Injectable)(),
    __param(1, (0, typeorm_1.InjectDataSource)('AdminConnection')),
    __metadata("design:paramtypes", [typeorm_2.DataSource,
        typeorm_2.DataSource,
        event_emitter_1.EventEmitter2])
], PhpPayrollReportService);
//# sourceMappingURL=php-payroll-report.service.js.map