"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PhpIpdReportService = void 0;
const common_1 = require("@nestjs/common");
const event_emitter_1 = require("@nestjs/event-emitter");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
let PhpIpdReportService = class PhpIpdReportService {
    constructor(connection, dynamicConnection, eventEmitter) {
        this.connection = connection;
        this.dynamicConnection = dynamicConnection;
        this.eventEmitter = eventEmitter;
    }
    async create(createPhpAppointmentReportDto, limit, page, search) {
        const offset = limit * (page - 1);
        let query = `
  SELECT 
    ipd_details.id,
    'ipd_no' AS module_no,
    ipd_details.symptoms,
    ipd_details.date,
    ipd_prescription_basic.finding_description,
    patients.patient_name,
    patients.dob,
    patients.age,
    patients.month,
    patients.day,
    patients.gender,
    patients.mobileno,
    patients.guardian_name,
    patients.address,
    patients.id AS patientid,
    staff.name,
    staff.surname,
    staff.employee_id

FROM ipd_details
LEFT JOIN ipd_prescription_basic 
    ON ipd_prescription_basic.ipd_id = ipd_details.id
LEFT JOIN patients 
    ON patients.id = ipd_details.patient_id
LEFT JOIN staff 
    ON staff.id = ipd_details.cons_doctor

WHERE DATE(ipd_details.date) BETWEEN DATE(?) AND DATE(?)
    `;
        let countQuery = `
      SELECT COUNT(ipd_details.id) AS total 
     
FROM ipd_details
LEFT JOIN ipd_prescription_basic 
    ON ipd_prescription_basic.ipd_id = ipd_details.id
LEFT JOIN patients 
    ON patients.id = ipd_details.patient_id
LEFT JOIN staff 
    ON staff.id = ipd_details.cons_doctor
  where
  DATE(ipd_details.date) BETWEEN DATE(?) AND DATE(?)
    `;
        const queryParams = [createPhpAppointmentReportDto.fromDate, createPhpAppointmentReportDto.toDate];
        if (createPhpAppointmentReportDto.doctorId) {
            query += ` AND staff.id = ? `;
            countQuery += ` AND staff.id = ? `;
            queryParams.push(createPhpAppointmentReportDto.doctorId);
        }
        if (createPhpAppointmentReportDto.symptoms) {
            query += ` AND ipd_details.symptoms LIKE ? `;
            countQuery += ` AND ipd_details.symptoms LIKE ?`;
            queryParams.push(createPhpAppointmentReportDto.symptoms);
        }
        if (createPhpAppointmentReportDto.gender) {
            query += `     AND LOWER(patients.gender) = ? `;
            countQuery += `     AND LOWER(patients.gender) = ? `;
            queryParams.push(createPhpAppointmentReportDto.gender.toLocaleLowerCase());
        }
        if (createPhpAppointmentReportDto.findings) {
            query += `  AND ipd_prescription_basic.finding_description LIKE ? `;
            countQuery += `  AND ipd_prescription_basic.finding_description LIKE ? `;
            queryParams.push(createPhpAppointmentReportDto.findings);
        }
        if (createPhpAppointmentReportDto.fromAge || createPhpAppointmentReportDto.toAge) {
            query += `  AND patients.age BETWEEN ? AND ? `;
            countQuery += `  AND patients.age BETWEEN ? AND ? `;
            queryParams.push(createPhpAppointmentReportDto.fromAge || 0, createPhpAppointmentReportDto.toAge || 200);
        }
        if (search) {
            const likeSearch = [`%${search}%`, `%${search}%`, `%${search}%`, `%${search}%`];
            query += ` AND (patients.patient_name LIKE ? OR patients.mobileno LIKE ? OR staff.name LIKE ? OR staff.surname LIKE ?)`;
            countQuery += ` AND (patients.patient_name LIKE ? OR patients.mobileno LIKE ? OR staff.name LIKE ? OR staff.surname LIKE ?)`;
            queryParams.push(...likeSearch);
        }
        query += ` ORDER BY ipd_details.date DESC LIMIT ? OFFSET ?`;
        queryParams.push(limit, offset);
        try {
            const data = await this.connection.query(query, queryParams);
            const [countData] = await this.connection.query(countQuery, queryParams);
            return {
                details: data,
                count: countData?.total ?? 0
            };
        }
        catch (error) {
            console.error("SQL Error:", error);
            throw error;
        }
    }
    findAll() {
        return `This action returns all phpIpdReport`;
    }
    findOne(id) {
        return `This action returns a #${id} phpIpdReport`;
    }
    update(id, updatePhpIpdReportDto) {
        return `This action updates a #${id} phpIpdReport`;
    }
    remove(id) {
        return `This action removes a #${id} phpIpdReport`;
    }
};
exports.PhpIpdReportService = PhpIpdReportService;
exports.PhpIpdReportService = PhpIpdReportService = __decorate([
    (0, common_1.Injectable)(),
    __param(1, (0, typeorm_1.InjectDataSource)('AdminConnection')),
    __metadata("design:paramtypes", [typeorm_2.DataSource,
        typeorm_2.DataSource,
        event_emitter_1.EventEmitter2])
], PhpIpdReportService);
//# sourceMappingURL=php-ipd-report.service.js.map