"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PhpInventoryController = void 0;
const common_1 = require("@nestjs/common");
const php_inventory_service_1 = require("./php-inventory.service");
const php_inventory_entity_1 = require("./entities/php-inventory.entity");
let PhpInventoryController = class PhpInventoryController {
    constructor(phpInventoryService) {
        this.phpInventoryService = phpInventoryService;
    }
    createItems(createPhpInventoryDto) {
        return this.phpInventoryService.createItem(createPhpInventoryDto);
    }
    create(createPhpInventoryDto) {
        return this.phpInventoryService.createItemIssue(createPhpInventoryDto);
    }
    createItemsStock(createPhpInventoryDto) {
        return this.phpInventoryService.createItemStock(createPhpInventoryDto);
    }
    findAllitems() {
        return this.phpInventoryService.findAllitems();
    }
    findAllitemsStock() {
        return this.phpInventoryService.findAllitems_stock();
    }
    findAll() {
        return this.phpInventoryService.findAllitems_issue();
    }
    updateitem(id, updatePhpInventoryDto) {
        return this.phpInventoryService.updateItems(+id, updatePhpInventoryDto);
    }
    updateitemStock(id, updatePhpInventoryDto) {
        return this.phpInventoryService.updateItemStock(+id, updatePhpInventoryDto);
    }
    update(id, updatePhpInventoryDto) {
        return this.phpInventoryService.update(+id, updatePhpInventoryDto);
    }
    removeItems(id, hospital_id) {
        return this.phpInventoryService.removeitem(+id, hospital_id);
    }
    removeItemsstock(id, hospital_id) {
        return this.phpInventoryService.removeitemStock(+id, hospital_id);
    }
    remove(id, hospital_id) {
        return this.phpInventoryService.remove(+id, hospital_id);
    }
};
exports.PhpInventoryController = PhpInventoryController;
__decorate([
    (0, common_1.Post)('item'),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [php_inventory_entity_1.PhpInventory]),
    __metadata("design:returntype", void 0)
], PhpInventoryController.prototype, "createItems", null);
__decorate([
    (0, common_1.Post)('item-issue'),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [php_inventory_entity_1.PhpInventory]),
    __metadata("design:returntype", void 0)
], PhpInventoryController.prototype, "create", null);
__decorate([
    (0, common_1.Post)('item-stock'),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [php_inventory_entity_1.PhpInventory]),
    __metadata("design:returntype", void 0)
], PhpInventoryController.prototype, "createItemsStock", null);
__decorate([
    (0, common_1.Get)('item'),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], PhpInventoryController.prototype, "findAllitems", null);
__decorate([
    (0, common_1.Get)('item-stock'),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], PhpInventoryController.prototype, "findAllitemsStock", null);
__decorate([
    (0, common_1.Get)('item-issue'),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], PhpInventoryController.prototype, "findAll", null);
__decorate([
    (0, common_1.Patch)('item/:id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, php_inventory_entity_1.PhpInventory]),
    __metadata("design:returntype", void 0)
], PhpInventoryController.prototype, "updateitem", null);
__decorate([
    (0, common_1.Patch)('item-stock/:id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, php_inventory_entity_1.PhpInventory]),
    __metadata("design:returntype", void 0)
], PhpInventoryController.prototype, "updateitemStock", null);
__decorate([
    (0, common_1.Patch)('item-issue/:id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, php_inventory_entity_1.PhpInventory]),
    __metadata("design:returntype", void 0)
], PhpInventoryController.prototype, "update", null);
__decorate([
    (0, common_1.Delete)('/item/:id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Query)('hospital_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Object]),
    __metadata("design:returntype", void 0)
], PhpInventoryController.prototype, "removeItems", null);
__decorate([
    (0, common_1.Delete)('/item-stock/:id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Query)('hospital_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Object]),
    __metadata("design:returntype", void 0)
], PhpInventoryController.prototype, "removeItemsstock", null);
__decorate([
    (0, common_1.Delete)('/item-issue/:id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Query)('hospital_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Object]),
    __metadata("design:returntype", void 0)
], PhpInventoryController.prototype, "remove", null);
exports.PhpInventoryController = PhpInventoryController = __decorate([
    (0, common_1.Controller)('php-inventory'),
    __metadata("design:paramtypes", [php_inventory_service_1.PhpInventoryService])
], PhpInventoryController);
//# sourceMappingURL=php-inventory.controller.js.map