"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PhpIncomeReportService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
let PhpIncomeReportService = class PhpIncomeReportService {
    constructor(connection, dynamicConnection) {
        this.connection = connection;
        this.dynamicConnection = dynamicConnection;
    }
    async create(createPhpIncomeReportDto, limit, page, search) {
        const offset = limit * (page - 1);
        let query = ` select transactions.id bill_no,
  DATE(transactions.payment_date) bill_date,
  patients.patient_name,
  staff.name staff_first_name,
  staff.surname staff_last_name,
  transactions.amount,
  transactions.payment_mode,
  transactions.section from transactions
  left join patients on patients.id = transactions.patient_id
  left join visit_details on visit_details.opd_details_id = transactions.opd_id
  left join ipd_details on ipd_details.id = transactions.ipd_id
  left join staff on staff.id = (ipd_details.cons_doctor or visit_details.cons_doctor) `;
        let countQuery = ` select count(transactions.id) as total from transactions
    left join patients on patients.id = transactions.patient_id
  left join visit_details on visit_details.opd_details_id = transactions.opd_id
  left join ipd_details on ipd_details.id = transactions.ipd_id
  left join staff on staff.id = (ipd_details.cons_doctor or visit_details.cons_doctor) `;
        let values = [];
        if (search) {
            query += ` where transactions.payment_mode like ? or transactions.section like ? or patients.patient_name like ? or staff.name like ? or staff.surname like ?`;
            countQuery += ` where transactions.payment_mode like ? or transactions.section like ? or patients.patient_name like ? or staff.name like ? or staff.surname like ?`;
            values.push(`%${search}%`, `%${search}%`, `%${search}%`, `%${search}%`, `%${search}%`);
        }
        query += ` limit  ${limit} offset ${offset} `;
        const getHeader = await this.connection.query(`SELECT 
  transactions.payment_mode,
  SUM(IFNULL(amount, 0) + IFNULL(temp_appt_amount, 0)) AS totalAmount 
FROM transactions
group by payment_mode`);
        const getValue = await this.connection.query(query, values);
        const getCount = await this.connection.query(countQuery, values);
        let out = {
            details: getValue,
            count: getCount[0]?.total ?? 0,
            header: getHeader
        };
        return out;
    }
    async findAll(limit, page, search) {
        const offset = limit * (page - 1);
        let query = ` SELECT 
  DATE_FORMAT(payment_date, '%Y-%m-%d') AS paymentDate,
  SUM(IFNULL(amount, 0) + IFNULL(temp_appt_amount, 0)) AS totalAmount,
  SUM(IF(LOWER(section) = 'appointment', IFNULL(amount, 0) + IFNULL(temp_appt_amount, 0), 0)) AS appointmentAmount,
  SUM(IF(LOWER(section) = 'opd', IFNULL(amount, 0) + IFNULL(temp_appt_amount, 0), 0)) AS opdAmount,
  SUM(IF(LOWER(section) = 'ipd', IFNULL(amount, 0) + IFNULL(temp_appt_amount, 0), 0)) AS ipdAmount,
  SUM(IF(LOWER(section) NOT IN ('opd', 'ipd','appointment'), IFNULL(amount, 0) + IFNULL(temp_appt_amount, 0), 0)) AS otherAmount
FROM transactions
`;
        let countQuery = ` SELECT COUNT(DISTINCT DATE(payment_date)) AS total
FROM transactions  `;
        let values = [];
        if (search) {
            query += ` where DATE(payment_date) like ?`;
            countQuery += ` where DATE(payment_date) like ?`;
            values.push(`%${search}%`);
        }
        query += ` GROUP BY DATE(payment_date)
ORDER BY DATE(payment_date) limit ${limit} offset ${offset}  `;
        const getHeader = await this.connection.query(`SELECT 
  transactions.payment_mode,
  SUM(IFNULL(amount, 0) + IFNULL(temp_appt_amount, 0)) AS totalAmount 
FROM transactions
group by payment_mode`);
        let reslt = await this.connection.query(query, values);
        let count = await this.connection.query(countQuery, values);
        let out = {
            details: reslt,
            count: count[0]?.total ?? 0,
            header: getHeader
        };
        return out;
    }
    async findAllPerMonth(limit, page) {
        const offset = limit * (page - 1);
        let query = ` SELECT 
  DATE_FORMAT(payment_date, '%Y-%m') AS paymentMonth,
  SUM(IFNULL(amount, 0) + IFNULL(temp_appt_amount, 0)) AS totalAmount
  -- ,
--  SUM(IF(LOWER(section) = 'appointment', IFNULL(amount, 0) + IFNULL(temp_appt_amount, 0), 0)) AS appointmentAmount,
 -- SUM(IF(LOWER(section) = 'opd', IFNULL(amount, 0) + IFNULL(temp_appt_amount, 0), 0)) AS opdAmount,
 -- SUM(IF(LOWER(section) = 'ipd', IFNULL(amount, 0) + IFNULL(temp_appt_amount, 0), 0)) AS ipdAmount,
--  SUM(IF(LOWER(section) NOT IN ('opd', 'ipd', 'appointment'), IFNULL(amount, 0) + IFNULL(temp_appt_amount, 0), 0)) AS otherAmount
FROM transactions


`;
        let countQuery = ` SELECT COUNT(DISTINCT DATE_FORMAT(payment_date, '%Y-%m')) AS total
FROM transactions   `;
        let values = [];
        query += ` GROUP BY DATE_FORMAT(payment_date, '%Y-%m')
ORDER BY paymentMonth limit ${limit} offset ${offset}  `;
        const getHeader = await this.connection.query(`SELECT 
  transactions.payment_mode,
  SUM(IFNULL(amount, 0) + IFNULL(temp_appt_amount, 0)) AS totalAmount 
FROM transactions
group by payment_mode`);
        let reslt = await this.connection.query(query, values);
        let count = await this.connection.query(countQuery, values);
        let out = {
            details: reslt,
            count: count[0]?.total ?? 0,
            header: getHeader
        };
        return out;
    }
    async findAllPerDoctor(limit, page, search) {
        const offset = limit * (page - 1);
        let query = ` SELECT 
  staff.name AS staff_first_name,
  staff.surname AS staff_last_name,
  SUM(IFNULL(amount, 0) + IFNULL(temp_appt_amount, 0)) AS totalAmount,
  SUM(IF(LOWER(section) = 'appointment', IFNULL(amount, 0) + IFNULL(temp_appt_amount, 0), 0)) AS appointmentAmount,
  SUM(IF(LOWER(section) = 'opd', IFNULL(amount, 0) + IFNULL(temp_appt_amount, 0), 0)) AS opdAmount,
  SUM(IF(LOWER(section) = 'ipd', IFNULL(amount, 0) + IFNULL(temp_appt_amount, 0), 0)) AS ipdAmount,
  SUM(IF(LOWER(section) NOT IN ('opd', 'ipd', 'appointment'), IFNULL(amount, 0) + IFNULL(temp_appt_amount, 0), 0)) AS otherAmount
FROM transactions
LEFT JOIN visit_details ON visit_details.opd_details_id = transactions.opd_id
LEFT JOIN ipd_details ON ipd_details.id = transactions.ipd_id
LEFT JOIN staff ON staff.id = COALESCE(ipd_details.cons_doctor, visit_details.cons_doctor)

`;
        let countQuery = `SELECT 
  COUNT(DISTINCT staff.id) AS total
FROM transactions
LEFT JOIN visit_details ON visit_details.opd_details_id = transactions.opd_id
LEFT JOIN ipd_details ON ipd_details.id = transactions.ipd_id
LEFT JOIN staff ON staff.id = COALESCE(ipd_details.cons_doctor, visit_details.cons_doctor)
   `;
        let values = [];
        if (search) {
            query += ` where staff.name like ? or staff.surname like ?`;
            countQuery += ` where staff.name like ? or staff.surname like ?`;
            values.push(`%${search}%`, `%${search}%`);
        }
        query += ` GROUP BY staff.id
ORDER BY  staff_first_name limit ${limit} offset ${offset}  `;
        const getHeader = await this.connection.query(`SELECT 
  transactions.payment_mode,
  SUM(IFNULL(amount, 0) + IFNULL(temp_appt_amount, 0)) AS totalAmount 
FROM transactions
group by payment_mode`);
        let reslt = await this.connection.query(query, values);
        let count = await this.connection.query(countQuery, values);
        let out = {
            details: reslt,
            count: count[0]?.total ?? 0,
            header: getHeader
        };
        return out;
    }
    async findAllPerPatient(limit, page, search) {
        const offset = limit * (page - 1);
        let query = ` SELECT 
    patients.patient_name,
    patients.id as patient_id,
    patients.mobileno,
    patients.gender,
    patients.age,
    patients.dob,
    patients.address,
    patients.state_name,
    patients.district_name,
  SUM(IFNULL(amount, 0) + IFNULL(temp_appt_amount, 0)) AS totalAmount,
  SUM(IF(LOWER(section) = 'appointment', IFNULL(amount, 0) + IFNULL(temp_appt_amount, 0), 0)) AS appointmentAmount,
  SUM(IF(LOWER(section) = 'opd', IFNULL(amount, 0) + IFNULL(temp_appt_amount, 0), 0)) AS opdAmount,
  SUM(IF(LOWER(section) = 'ipd', IFNULL(amount, 0) + IFNULL(temp_appt_amount, 0), 0)) AS ipdAmount,
  SUM(IF(LOWER(section) NOT IN ('opd', 'ipd', 'appointment'), IFNULL(amount, 0) + IFNULL(temp_appt_amount, 0), 0)) AS otherAmount
FROM transactions
LEFT JOIN patients ON patients.id = transactions.patient_id

`;
        let countQuery = `SELECT 
  COUNT(DISTINCT patients.id) AS total
FROM transactions
LEFT JOIN patients ON patients.id = transactions.patient_id
   `;
        let values = [];
        if (search) {
            query += ` where  patients.patient_name like ? or patients.id like ? or patients.mobileno like ? or patients.address ? or patients.state_name ?`;
            countQuery += ` where  patients.patient_name like ? or patients.id like ? or patients.mobileno like ? or patients.address ? or patients.state_name ? `;
            values.push(`%${search}%`, `%${search}%`, `%${search}%`, `%${search}%`, `%${search}%`);
        }
        query += ` GROUP BY patients.id
ORDER BY patients.patient_name limit ${limit} offset ${offset}  `;
        const getHeader = await this.connection.query(`SELECT 
  transactions.payment_mode,
  SUM(IFNULL(amount, 0) + IFNULL(temp_appt_amount, 0)) AS totalAmount 
FROM transactions
group by payment_mode`);
        let reslt = await this.connection.query(query, values);
        let count = await this.connection.query(countQuery, values);
        let out = {
            details: reslt,
            count: count[0]?.total ?? 0,
            header: getHeader
        };
        return out;
    }
    findOne(id) {
        return `This action returns a #${id} phpIncomeReport`;
    }
    update(id, updatePhpIncomeReportDto) {
        return `This action updates a #${id} phpIncomeReport`;
    }
    remove(id) {
        return `This action removes a #${id} phpIncomeReport`;
    }
};
exports.PhpIncomeReportService = PhpIncomeReportService;
exports.PhpIncomeReportService = PhpIncomeReportService = __decorate([
    (0, common_1.Injectable)(),
    __param(1, (0, typeorm_1.InjectDataSource)('AdminConnection')),
    __metadata("design:paramtypes", [typeorm_2.DataSource,
        typeorm_2.DataSource])
], PhpIncomeReportService);
//# sourceMappingURL=php-income-report.service.js.map