"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PhpExpenseReportService = void 0;
const common_1 = require("@nestjs/common");
const event_emitter_1 = require("@nestjs/event-emitter");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
let PhpExpenseReportService = class PhpExpenseReportService {
    constructor(connection, dynamicConnection, eventEmitter) {
        this.connection = connection;
        this.dynamicConnection = dynamicConnection;
        this.eventEmitter = eventEmitter;
    }
    async create(createPhpAppointmentReportDto, limit, page, search) {
        const offset = limit * (page - 1);
        let query = `
      SELECT 
    expenses.*,
    expense_head.exp_category
FROM 
    expenses
LEFT JOIN 
    expense_head ON expense_head.id = expenses.exp_head_id
 WHERE 1=1


    `;
        let countQuery = `
       SELECT 
    COUNT(expenses.id) AS total
FROM 
    expenses
    WHERE 1=1
    `;
        const queryParams = [];
        if (createPhpAppointmentReportDto.fromDate && createPhpAppointmentReportDto.toDate) {
            query += ` AND
      DATE(expenses.date) BETWEEN DATE(?) AND DATE(?) `;
            countQuery += ` AND
      DATE(expenses.date) BETWEEN DATE(?) AND DATE(?) `;
            queryParams.push(createPhpAppointmentReportDto.fromDate, createPhpAppointmentReportDto.toDate);
        }
        if (search) {
            const likeSearch = [`%${search}%`, `%${search}%`, `%${search}%`, `%${search}%`];
            query += ` AND (expenses.name LIKE ? OR expenses.invoice_no LIKE ? OR expenses.date LIKE ? OR expense_head.exp_category LIKE ?)`;
            countQuery += `  AND (expenses.name LIKE ? OR expenses.invoice_no LIKE ? OR expenses.date LIKE ? OR expense_head.exp_category LIKE ?) `;
            queryParams.push(...likeSearch);
        }
        query += `  LIMIT ? OFFSET ?`;
        queryParams.push(limit, offset);
        try {
            const data = await this.connection.query(query, queryParams);
            const [countData] = await this.connection.query(countQuery, queryParams);
            return {
                details: data,
                count: countData?.total ?? 0
            };
        }
        catch (error) {
            console.error("SQL Error:", error);
            throw error;
        }
    }
    findAll() {
        return `This action returns all phpExpenseReport`;
    }
    findOne(id) {
        return `This action returns a #${id} phpExpenseReport`;
    }
    update(id, updatePhpExpenseReportDto) {
        return `This action updates a #${id} phpExpenseReport`;
    }
    remove(id) {
        return `This action removes a #${id} phpExpenseReport`;
    }
};
exports.PhpExpenseReportService = PhpExpenseReportService;
exports.PhpExpenseReportService = PhpExpenseReportService = __decorate([
    (0, common_1.Injectable)(),
    __param(1, (0, typeorm_1.InjectDataSource)('AdminConnection')),
    __metadata("design:paramtypes", [typeorm_2.DataSource,
        typeorm_2.DataSource,
        event_emitter_1.EventEmitter2])
], PhpExpenseReportService);
//# sourceMappingURL=php-expense-report.service.js.map