"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PhpExpenseReportController = void 0;
const common_1 = require("@nestjs/common");
const php_expense_report_service_1 = require("./php-expense-report.service");
const create_php_expense_report_dto_1 = require("./dto/create-php-expense-report.dto");
const update_php_expense_report_dto_1 = require("./dto/update-php-expense-report.dto");
const auth_guard_1 = require("../auth/auth.guard");
let PhpExpenseReportController = class PhpExpenseReportController {
    constructor(phpExpenseReportService) {
        this.phpExpenseReportService = phpExpenseReportService;
    }
    async create(createPhpExpenseReportDto, limit, page, search) {
        try {
            let final_out = await this.phpExpenseReportService.create(createPhpExpenseReportDto, Number(limit) || 10, page || 1, search);
            if (final_out?.details.length > 0) {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE_V2,
                    status: process.env.SUCCESS_STATUS_V2,
                    message: process.env.SUCCESS_MESSAGE_V2,
                    data: final_out.details,
                    total: final_out.count,
                };
            }
            else {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE_V2,
                    status: process.env.SUCCESS_STATUS_V2,
                    message: process.env.DATA_NOT_FOUND_V2
                };
            }
        }
        catch (error) {
            return {
                status_code: process.env.ERROR_STATUS_CODE_V2,
                "status": process.env.ERROR_STATUS_V2,
                "message": process.env.ERROR_MESSAGE_V2,
            };
        }
    }
    findAll() {
        return this.phpExpenseReportService.findAll();
    }
    findOne(id) {
        return this.phpExpenseReportService.findOne(+id);
    }
    update(id, updatePhpExpenseReportDto) {
        return this.phpExpenseReportService.update(+id, updatePhpExpenseReportDto);
    }
    remove(id) {
        return this.phpExpenseReportService.remove(+id);
    }
};
exports.PhpExpenseReportController = PhpExpenseReportController;
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Post)(),
    __param(0, (0, common_1.Body)()),
    __param(1, (0, common_1.Query)('limit')),
    __param(2, (0, common_1.Query)('page')),
    __param(3, (0, common_1.Query)('search')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [create_php_expense_report_dto_1.CreatePhpExpenseReportDto, Number, Number, String]),
    __metadata("design:returntype", Promise)
], PhpExpenseReportController.prototype, "create", null);
__decorate([
    (0, common_1.Get)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], PhpExpenseReportController.prototype, "findAll", null);
__decorate([
    (0, common_1.Get)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], PhpExpenseReportController.prototype, "findOne", null);
__decorate([
    (0, common_1.Patch)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, update_php_expense_report_dto_1.UpdatePhpExpenseReportDto]),
    __metadata("design:returntype", void 0)
], PhpExpenseReportController.prototype, "update", null);
__decorate([
    (0, common_1.Delete)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], PhpExpenseReportController.prototype, "remove", null);
exports.PhpExpenseReportController = PhpExpenseReportController = __decorate([
    (0, common_1.Controller)('php-expense-report'),
    __metadata("design:paramtypes", [php_expense_report_service_1.PhpExpenseReportService])
], PhpExpenseReportController);
//# sourceMappingURL=php-expense-report.controller.js.map