"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PhpDailyTransactionSummaryReportController = void 0;
const common_1 = require("@nestjs/common");
const php_daily_transaction_summary_report_service_1 = require("./php-daily-transaction-summary-report.service");
const create_php_daily_transaction_summary_report_dto_1 = require("./dto/create-php-daily-transaction-summary-report.dto");
const update_php_daily_transaction_summary_report_dto_1 = require("./dto/update-php-daily-transaction-summary-report.dto");
const auth_guard_1 = require("../auth/auth.guard");
let PhpDailyTransactionSummaryReportController = class PhpDailyTransactionSummaryReportController {
    constructor(phpDailyTransactionSummaryReportService) {
        this.phpDailyTransactionSummaryReportService = phpDailyTransactionSummaryReportService;
    }
    async create(createPhpDailyTransactionSummaryReportDto) {
        if (!createPhpDailyTransactionSummaryReportDto.fromDate || !createPhpDailyTransactionSummaryReportDto.toDate) {
            return {
                status_code: process.env.ERROR_STATUS_CODE_PARAM_MISSING,
                status: process.env.ERROR_STATUS,
                message: process.env.ERROR_MESSAGE_PARAM_MISSING
            };
        }
        try {
            let final_out = await this.phpDailyTransactionSummaryReportService.create(createPhpDailyTransactionSummaryReportDto);
            console.log(final_out, "final_out");
            if (final_out) {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE_V2,
                    status: process.env.SUCCESS_STATUS_V2,
                    message: process.env.SUCCESS_MESSAGE_V2,
                    data: final_out,
                };
            }
            else {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE_V2,
                    status: process.env.SUCCESS_STATUS_V2,
                    message: process.env.DATA_NOT_FOUND_V2
                };
            }
        }
        catch (error) {
            return {
                status_code: process.env.ERROR_STATUS_CODE_V2,
                "status": process.env.ERROR_STATUS_V2,
                "message": process.env.ERROR_MESSAGE_V2,
            };
        }
    }
    async findAll(section, date) {
        if (!section || !date) {
            return {
                status_code: process.env.ERROR_STATUS_CODE_PARAM_MISSING,
                status: process.env.ERROR_STATUS,
                message: process.env.ERROR_MESSAGE_PARAM_MISSING
            };
        }
        try {
            let final_out = await this.phpDailyTransactionSummaryReportService.findAll(section, date);
            console.log(final_out, "final_out");
            if (final_out.length > 0) {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE_V2,
                    status: process.env.SUCCESS_STATUS_V2,
                    message: process.env.SUCCESS_MESSAGE_V2,
                    data: final_out,
                };
            }
            else {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE_V2,
                    status: process.env.SUCCESS_STATUS_V2,
                    message: process.env.DATA_NOT_FOUND_V2
                };
            }
        }
        catch (error) {
            return {
                status_code: process.env.ERROR_STATUS_CODE_V2,
                "status": process.env.ERROR_STATUS_V2,
                "message": process.env.ERROR_MESSAGE_V2,
            };
        }
    }
    async findOne(id, hospital_id) {
        if (!id || !hospital_id) {
            return {
                status_code: process.env.ERROR_STATUS_CODE_PARAM_MISSING,
                status: process.env.ERROR_STATUS,
                message: process.env.ERROR_MESSAGE_PARAM_MISSING
            };
        }
        try {
            let final_out = await this.phpDailyTransactionSummaryReportService.findOne(id, hospital_id);
            if (final_out.length > 0) {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE_V2,
                    status: process.env.SUCCESS_STATUS_V2,
                    message: process.env.SUCCESS_MESSAGE_V2,
                    data: final_out,
                };
            }
            else {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE_V2,
                    status: process.env.SUCCESS_STATUS_V2,
                    message: process.env.DATA_NOT_FOUND_V2
                };
            }
        }
        catch (error) {
            return {
                status_code: process.env.ERROR_STATUS_CODE_V2,
                "status": process.env.ERROR_STATUS_V2,
                "message": process.env.ERROR_MESSAGE_V2,
            };
        }
        return this.phpDailyTransactionSummaryReportService.findOne(id, hospital_id);
    }
    update(id, updatePhpDailyTransactionSummaryReportDto) {
        return this.phpDailyTransactionSummaryReportService.update(+id, updatePhpDailyTransactionSummaryReportDto);
    }
    remove(id) {
        return this.phpDailyTransactionSummaryReportService.remove(+id);
    }
};
exports.PhpDailyTransactionSummaryReportController = PhpDailyTransactionSummaryReportController;
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Post)(),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [create_php_daily_transaction_summary_report_dto_1.CreatePhpDailyTransactionSummaryReportDto]),
    __metadata("design:returntype", Promise)
], PhpDailyTransactionSummaryReportController.prototype, "create", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)(),
    __param(0, (0, common_1.Query)('section')),
    __param(1, (0, common_1.Query)('date')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, String]),
    __metadata("design:returntype", Promise)
], PhpDailyTransactionSummaryReportController.prototype, "findAll", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Query)('hospital_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, String]),
    __metadata("design:returntype", Promise)
], PhpDailyTransactionSummaryReportController.prototype, "findOne", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Patch)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, update_php_daily_transaction_summary_report_dto_1.UpdatePhpDailyTransactionSummaryReportDto]),
    __metadata("design:returntype", void 0)
], PhpDailyTransactionSummaryReportController.prototype, "update", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Delete)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], PhpDailyTransactionSummaryReportController.prototype, "remove", null);
exports.PhpDailyTransactionSummaryReportController = PhpDailyTransactionSummaryReportController = __decorate([
    (0, common_1.Controller)('php-daily-transaction-summary-report'),
    __metadata("design:paramtypes", [php_daily_transaction_summary_report_service_1.PhpDailyTransactionSummaryReportService])
], PhpDailyTransactionSummaryReportController);
//# sourceMappingURL=php-daily-transaction-summary-report.controller.js.map