"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PhpCollectionByReportService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
let PhpCollectionByReportService = class PhpCollectionByReportService {
    constructor(connection, dynamicConnection) {
        this.connection = connection;
        this.dynamicConnection = dynamicConnection;
    }
    async create(createPhpCollectionByReportDto, limit, page, search) {
        try {
            const offset = limit * (page - 1);
            let query = `SELECT 
transactions.received_by_name collected_by,
  SUM(IFNULL(amount, 0) + IFNULL(temp_appt_amount, 0)) AS totalAmount,
  SUM(IF(LOWER(transactions.payment_mode) = 'cash', IFNULL(amount, 0) + IFNULL(temp_appt_amount, 0), 0)) AS cash,
  SUM(IF(LOWER(transactions.payment_mode) = 'card', IFNULL(amount, 0) + IFNULL(temp_appt_amount, 0), 0)) AS card,
  SUM(IF(LOWER(transactions.payment_mode) = 'dd', IFNULL(amount, 0) + IFNULL(temp_appt_amount, 0), 0)) AS dd,
  SUM(IF(LOWER(transactions.payment_mode) = 'neft', IFNULL(amount, 0) + IFNULL(temp_appt_amount, 0), 0)) AS neft,
  SUM(IF(LOWER(transactions.payment_mode) = 'upi', IFNULL(amount, 0) + IFNULL(temp_appt_amount, 0), 0)) AS upi,
  SUM(IF(LOWER(transactions.payment_mode) = 'scheme', IFNULL(amount, 0) + IFNULL(temp_appt_amount, 0), 0)) AS scheme,
  SUM(IF(LOWER(transactions.payment_mode) = 'online', IFNULL(amount, 0) + IFNULL(temp_appt_amount, 0), 0)) AS online,
    SUM(IF(LOWER(transactions.payment_mode) = 'paylater', IFNULL(amount, 0) + IFNULL(temp_appt_amount, 0), 0)) AS paylater,
    SUM(IF(LOWER(transactions.payment_mode) = 'offline', IFNULL(amount, 0) + IFNULL(temp_appt_amount, 0), 0)) AS offline
FROM transactions
where date(transactions.payment_date) BETWEEN DATE('${createPhpCollectionByReportDto.startDate}') AND DATE('${createPhpCollectionByReportDto.endDate}')
 `;
            let countQuery = `

  SELECT transactions.received_by_name
  FROM transactions
  WHERE DATE(transactions.payment_date) 
     BETWEEN DATE('${createPhpCollectionByReportDto.startDate}') 
  AND DATE('${createPhpCollectionByReportDto.endDate}') 


 `;
            if (search) {
                query += ` and transactions.received_by_name like '%${search}%' `;
                countQuery += ` and transactions.received_by_name like '%${search}%' `;
            }
            let finalOut = `  SELECT COUNT(*) AS count
FROM (
  ${countQuery} 
  GROUP BY transactions.received_by_name
) AS count`;
            let grpby = ` group by transactions.received_by_name limit ${limit} offset ${offset}`;
            const getOutput = await this.dynamicConnection.query(query + grpby);
            const getCount = await this.dynamicConnection.query(finalOut);
            let out = {
                details: getOutput,
                count: getCount[0]?.count ?? 0
            };
            return out;
        }
        catch (error) {
            console.log(error, "error");
            return error;
        }
    }
    findAll(name) {
        const getStaffDetails = `SELECT 
    staff.name AS firstname,
    staff.surname AS lastname,
    staff.employee_id AS employeeId,
    staff.contact_no AS mobile,
    department.department_name AS department,
    staff_designation.designation AS designation
FROM 
    staff 
LEFT JOIN 
    staff_designation ON staff.staff_designation_id = staff_designation.id
LEFT JOIN 
    department ON staff.department_id = department.id
WHERE 
    CONCAT(staff.name, ' ', staff.surname) LIKE ?
    OR CONCAT(staff.name, staff.surname) LIKE ?
`;
        const getOut = this.dynamicConnection.query(getStaffDetails, [`%${name}%`, `%${name}%`]);
        return getOut;
    }
    findOne(id) {
        return `This action returns a #${id} phpCollectionByReport`;
    }
    update(id, updatePhpCollectionByReportDto) {
        return `This action updates a #${id} phpCollectionByReport`;
    }
    remove(id) {
        return `This action removes a #${id} phpCollectionByReport`;
    }
};
exports.PhpCollectionByReportService = PhpCollectionByReportService;
exports.PhpCollectionByReportService = PhpCollectionByReportService = __decorate([
    (0, common_1.Injectable)(),
    __param(1, (0, typeorm_1.InjectDataSource)('AdminConnection')),
    __metadata("design:paramtypes", [typeorm_2.DataSource,
        typeorm_2.DataSource])
], PhpCollectionByReportService);
//# sourceMappingURL=php-collection_by-report.service.js.map