"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PhpCollectionByReportController = void 0;
const common_1 = require("@nestjs/common");
const php_collection_by_report_service_1 = require("./php-collection_by-report.service");
const create_php_collection_by_report_dto_1 = require("./dto/create-php-collection_by-report.dto");
const update_php_collection_by_report_dto_1 = require("./dto/update-php-collection_by-report.dto");
let PhpCollectionByReportController = class PhpCollectionByReportController {
    constructor(phpCollectionByReportService) {
        this.phpCollectionByReportService = phpCollectionByReportService;
    }
    async create(createPhpCollectionByReportDto, limit, page, search) {
        if (!createPhpCollectionByReportDto.startDate || !createPhpCollectionByReportDto.endDate) {
            return {
                status_code: process.env.ERROR_STATUS_CODE_PARAM_MISSING,
                status: process.env.ERROR_STATUS,
                message: process.env.ERROR_MESSAGE_PARAM_MISSING
            };
        }
        try {
            let final_out = await this.phpCollectionByReportService.create(createPhpCollectionByReportDto, limit || 10, page || 1, search);
            if (final_out?.details.length > 0) {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE_V2,
                    status: process.env.SUCCESS_STATUS_V2,
                    message: process.env.SUCCESS_MESSAGE_V2,
                    data: final_out.details,
                    total: final_out.count,
                };
            }
            else {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE_V2,
                    status: process.env.SUCCESS_STATUS_V2,
                    message: process.env.DATA_NOT_FOUND_V2
                };
            }
        }
        catch (error) {
            return {
                status_code: process.env.ERROR_STATUS_CODE_V2,
                "status": process.env.ERROR_STATUS_V2,
                "message": process.env.ERROR_MESSAGE_V2,
            };
        }
    }
    findAll(name) {
        return this.phpCollectionByReportService.findAll(name);
    }
    findOne(id) {
        return this.phpCollectionByReportService.findOne(+id);
    }
    update(id, updatePhpCollectionByReportDto) {
        return this.phpCollectionByReportService.update(+id, updatePhpCollectionByReportDto);
    }
    remove(id) {
        return this.phpCollectionByReportService.remove(+id);
    }
};
exports.PhpCollectionByReportController = PhpCollectionByReportController;
__decorate([
    (0, common_1.Post)(),
    __param(0, (0, common_1.Body)()),
    __param(1, (0, common_1.Query)('limit')),
    __param(2, (0, common_1.Query)('page')),
    __param(3, (0, common_1.Query)('search')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [create_php_collection_by_report_dto_1.CreatePhpCollectionByReportDto, Number, Number, String]),
    __metadata("design:returntype", Promise)
], PhpCollectionByReportController.prototype, "create", null);
__decorate([
    (0, common_1.Get)(),
    __param(0, (0, common_1.Query)('name')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], PhpCollectionByReportController.prototype, "findAll", null);
__decorate([
    (0, common_1.Get)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], PhpCollectionByReportController.prototype, "findOne", null);
__decorate([
    (0, common_1.Patch)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, update_php_collection_by_report_dto_1.UpdatePhpCollectionByReportDto]),
    __metadata("design:returntype", void 0)
], PhpCollectionByReportController.prototype, "update", null);
__decorate([
    (0, common_1.Delete)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], PhpCollectionByReportController.prototype, "remove", null);
exports.PhpCollectionByReportController = PhpCollectionByReportController = __decorate([
    (0, common_1.Controller)('php-collection-by-report'),
    __metadata("design:paramtypes", [php_collection_by_report_service_1.PhpCollectionByReportService])
], PhpCollectionByReportController);
//# sourceMappingURL=php-collection_by-report.controller.js.map