"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PhpAppointmentReportService = void 0;
const common_1 = require("@nestjs/common");
const event_emitter_1 = require("@nestjs/event-emitter");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
let PhpAppointmentReportService = class PhpAppointmentReportService {
    constructor(connection, dynamicConnection, eventEmitter) {
        this.connection = connection;
        this.dynamicConnection = dynamicConnection;
        this.eventEmitter = eventEmitter;
    }
    async create(createPhpAppointmentReportDto, limit, page, search) {
        const offset = limit * (page - 1);
        let query = `
      SELECT 
        appointment.*, 
        patients.mobileno, 
        patients.email, 
        patients.gender, 
        appointment_payment.paid_amount, 
        patients.patient_name, 
        patients.id AS patient_id, 
        staff.name, 
        staff.surname, 
        staff.employee_id
      FROM appointment
      JOIN appointment_payment 
        ON appointment_payment.appointment_id = appointment.id
      JOIN patients 
        ON patients.id = appointment.patient_id
      LEFT JOIN staff 
        ON staff.id = appointment.doctor
      WHERE DATE(appointment.date) >= DATE(?) 
        AND DATE(appointment.date) <= DATE(?)
    `;
        let countQuery = `
      SELECT COUNT(appointment.id) AS total 
      FROM appointment 
            LEFT JOIN staff 
        ON staff.id = appointment.doctor
         JOIN patients 
        ON patients.id = appointment.patient_id
         JOIN appointment_payment 
        ON appointment_payment.appointment_id = appointment.id
      WHERE DATE(appointment.date) >= DATE(?) 
        AND DATE(appointment.date) <= DATE(?)
    `;
        const queryParams = [
            createPhpAppointmentReportDto.fromDate,
            createPhpAppointmentReportDto.toDate,
        ];
        if (createPhpAppointmentReportDto.doctorId) {
            query += ` AND appointment.doctor = ?`;
            countQuery += ` AND appointment.doctor = ?`;
            queryParams.push(createPhpAppointmentReportDto.doctorId);
        }
        if (createPhpAppointmentReportDto.shiftId) {
            query += ` AND appointment.global_shift_id = ?`;
            countQuery += ` AND appointment.global_shift_id = ?`;
            queryParams.push(createPhpAppointmentReportDto.shiftId);
        }
        if (createPhpAppointmentReportDto.priority) {
            query += ` AND appointment.priority = ?`;
            countQuery += ` AND appointment.priority = ?`;
            queryParams.push(createPhpAppointmentReportDto.priority);
        }
        if (createPhpAppointmentReportDto.source) {
            query += ` AND appointment.source = ?`;
            countQuery += ` AND appointment.source = ?`;
            queryParams.push(createPhpAppointmentReportDto.source);
        }
        if (search) {
            const likeSearch = [
                `%${search}%`,
                `%${search}%`,
                `%${search}%`,
                `%${search}%`,
            ];
            query += ` AND (patients.patient_name LIKE ? OR patients.mobileno LIKE ? OR staff.name LIKE ? OR staff.surname LIKE ?)`;
            countQuery += ` AND (patients.patient_name LIKE ? OR patients.mobileno LIKE ? OR staff.name LIKE ? OR staff.surname LIKE ?)`;
            queryParams.push(...likeSearch);
        }
        query += ` ORDER BY appointment.date DESC, appointment.time DESC LIMIT ? OFFSET ?`;
        queryParams.push(limit, offset);
        try {
            const data = await this.connection.query(query, queryParams);
            const [countData] = await this.connection.query(countQuery, queryParams);
            return {
                details: data,
                count: countData?.total ?? 0,
            };
        }
        catch (error) {
            throw error;
        }
    }
    findAll() {
        return `This action returns all phpAppointmentReport`;
    }
    findOne(id) {
        return `This action returns a #${id} phpAppointmentReport`;
    }
    update(id, updatePhpAppointmentReportDto) {
        return `This action updates a #${id} phpAppointmentReport`;
    }
    remove(id) {
        return `This action removes a #${id} phpAppointmentReport`;
    }
};
exports.PhpAppointmentReportService = PhpAppointmentReportService;
exports.PhpAppointmentReportService = PhpAppointmentReportService = __decorate([
    (0, common_1.Injectable)(),
    __param(1, (0, typeorm_1.InjectDataSource)('AdminConnection')),
    __metadata("design:paramtypes", [typeorm_2.DataSource,
        typeorm_2.DataSource,
        event_emitter_1.EventEmitter2])
], PhpAppointmentReportService);
//# sourceMappingURL=php-appointment-report.service.js.map