"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PhoneCallLogService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
let PhoneCallLogService = class PhoneCallLogService {
    constructor(connection, dynamicConnection) {
        this.connection = connection;
        this.dynamicConnection = dynamicConnection;
    }
    async create(createPhoneCallLog) {
        try {
            const addCalls = await this.connection.query(`INSERT into general_calls(
       name,
       contact,
       date,
       description,
       follow_up_date,
       call_duration,
       note,
       call_type
        ) VALUES (?,?,?,?,?,?,?,?)`, [
                createPhoneCallLog.name,
                createPhoneCallLog.contact,
                createPhoneCallLog.date,
                createPhoneCallLog.description,
                createPhoneCallLog.follow_up_date,
                createPhoneCallLog.call_duration,
                createPhoneCallLog.note,
                createPhoneCallLog.call_type
            ]);
            const addCallsID = addCalls.insertId;
            await this.dynamicConnection.query(`INSERT into general_calls(
       name,
       contact,
       date,
       description,
       follow_up_date,
       call_duration,
       note,
       call_type,
       hospital_id,
       hos_general_calls_id
          ) VALUES (?,?,?,?,?,?,?,?,?,?)`, [
                createPhoneCallLog.name,
                createPhoneCallLog.contact,
                createPhoneCallLog.date,
                createPhoneCallLog.description,
                createPhoneCallLog.follow_up_date,
                createPhoneCallLog.call_duration,
                createPhoneCallLog.note,
                createPhoneCallLog.call_type,
                createPhoneCallLog.hospital_id,
                addCallsID
            ]);
            return [{
                    "data ": {
                        status: "success",
                        "messege": "general calls added successfully ",
                        "calls_Details": await this.connection.query('SELECT * FROM general_calls WHERE id = ?', [addCallsID])
                    }
                }];
        }
        catch (error) {
            console.error('Error while posting data:', error);
        }
    }
    async update(id, createPhoneCallLog) {
        try {
            await this.connection.query(`update general_calls SET
      name=?,
       contact=?,
       date=?,
       description=?,
       follow_up_date=?,
       call_duration=?,
       note=?,
       call_type=?
       where id=?`, [
                createPhoneCallLog.name,
                createPhoneCallLog.contact,
                createPhoneCallLog.date,
                createPhoneCallLog.description,
                createPhoneCallLog.follow_up_date,
                createPhoneCallLog.call_duration,
                createPhoneCallLog.note,
                createPhoneCallLog.call_type,
                id
            ]);
            const [dynCallLogs] = await this.dynamicConnection.query(`select id from general_calls where hospital_id = ? and  hos_general_calls_id = ?`, [createPhoneCallLog.hospital_id, id]);
            const dynCallLogsID = dynCallLogs.id;
            await this.dynamicConnection.query(`update general_calls SET
       name=?,
       contact=?,
       date=?,
       description=?,
       follow_up_date=?,
       call_duration=?,
       note=?,
       call_type=?,
       hospital_id=?
       where id=?`, [
                createPhoneCallLog.name,
                createPhoneCallLog.contact,
                createPhoneCallLog.date,
                createPhoneCallLog.description,
                createPhoneCallLog.follow_up_date,
                createPhoneCallLog.call_duration,
                createPhoneCallLog.note,
                createPhoneCallLog.call_type,
                createPhoneCallLog.hospital_id,
                dynCallLogsID
            ]);
            return [{
                    "data ": {
                        status: "success",
                        "messege": "Call logs updated successfully ",
                        "updated_values": await this.connection.query('SELECT * FROM general_calls WHERE id = ?', [id])
                    }
                }];
        }
        catch (error) {
            console.error('Error while posting data:', error);
        }
    }
    async removeFrontofficeCallLogs(id, hospital_id) {
        try {
            await this.connection.query('DELETE FROM general_calls WHERE id = ?', [id]);
            await this.dynamicConnection.query('DELETE FROM general_calls WHERE hos_general_calls_id = ? and hospital_id = ?', [id, hospital_id]);
            return [
                {
                    status: 'success',
                    message: `General calls details with id: ${id} and associated entries in the dynamic database have been deleted.`,
                },
            ];
        }
        catch (error) {
            console.error('Error while posting data:', error);
        }
    }
};
exports.PhoneCallLogService = PhoneCallLogService;
exports.PhoneCallLogService = PhoneCallLogService = __decorate([
    (0, common_1.Injectable)(),
    __param(1, (0, typeorm_1.InjectDataSource)('AdminConnection')),
    __metadata("design:paramtypes", [typeorm_2.DataSource,
        typeorm_2.DataSource])
], PhoneCallLogService);
//# sourceMappingURL=phone_call_log.service.js.map