"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PharmacyGenerateBillController = void 0;
const common_1 = require("@nestjs/common");
const pharmacy_generate_bill_service_1 = require("./pharmacy_generate_bill.service");
const pharmacy_generate_bill_entity_1 = require("./entities/pharmacy_generate_bill.entity");
const auth_guard_1 = require("../auth/auth.guard");
let PharmacyGenerateBillController = class PharmacyGenerateBillController {
    constructor(pharmacyGenerateBillService) {
        this.pharmacyGenerateBillService = pharmacyGenerateBillService;
    }
    create(createPharmacyGenerateBill) {
        return this.pharmacyGenerateBillService.create(createPharmacyGenerateBill);
    }
    createMedicineBillDetails(createPurchaseMedicine) {
        return this.pharmacyGenerateBillService.createMedicineBillDetails(createPurchaseMedicine);
    }
    update(id, createPharmacyGenerateBill) {
        return this.pharmacyGenerateBillService.update(id, createPharmacyGenerateBill);
    }
    PharmaBillDetail(updatePharmaBillDetail) {
        return this.pharmacyGenerateBillService.PharmaBillDetail(updatePharmaBillDetail);
    }
    AddPayment(createPharmacyGenerateBill) {
        return this.pharmacyGenerateBillService.AddPayment(createPharmacyGenerateBill);
    }
    async removePharmacyBill(id, hospital_id) {
        await this.pharmacyGenerateBillService.removePharmacyBill(id, hospital_id);
        return {
            status: 'success',
            message: `id: ${id} deleted successfully`,
        };
    }
    async removePayment(id, Hospital_id) {
        await this.pharmacyGenerateBillService.removePayment(id, Hospital_id);
        return {
            status: 'success',
            message: `id: ${id} deleted successfully`,
        };
    }
    paymentsListByBillBasicID(id) {
        return this.pharmacyGenerateBillService.paymentsListByBillBasicID(id);
    }
    getPrescDetailsByprescID(id) {
        return this.pharmacyGenerateBillService.getPrescDetailsByprescID(id);
    }
    getmedicinedetailsByBatchno(id) {
        return this.pharmacyGenerateBillService.getmedicinedetailsByBatchno(id);
    }
    findAll() {
        return this.pharmacyGenerateBillService.findAll();
    }
    findPharmacyBillByAll(search) {
        return this.pharmacyGenerateBillService.findPharmacyBillByAll(search);
    }
    getPharmacybillbyID(id) {
        return this.pharmacyGenerateBillService.getPharmacybillbyID(id);
    }
    async removePharmaBillDetail(id, hospital_id) {
        await this.pharmacyGenerateBillService.removePharmaBillDetail(id, hospital_id);
        return {
            status: 'success',
            message: `id: ${id} deleted successfully`,
        };
    }
};
exports.PharmacyGenerateBillController = PharmacyGenerateBillController;
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Post)(),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [pharmacy_generate_bill_entity_1.PharmacyGenerateBill]),
    __metadata("design:returntype", void 0)
], PharmacyGenerateBillController.prototype, "create", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Post)('/medicineBillDetails'),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Array]),
    __metadata("design:returntype", void 0)
], PharmacyGenerateBillController.prototype, "createMedicineBillDetails", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Patch)('/:id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, pharmacy_generate_bill_entity_1.PharmacyGenerateBill]),
    __metadata("design:returntype", void 0)
], PharmacyGenerateBillController.prototype, "update", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Patch)('/billdetailupdate/PharmacyBillDetail'),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Array]),
    __metadata("design:returntype", void 0)
], PharmacyGenerateBillController.prototype, "PharmaBillDetail", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Post)('/AddPayment'),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [pharmacy_generate_bill_entity_1.PharmacyGenerateBill]),
    __metadata("design:returntype", void 0)
], PharmacyGenerateBillController.prototype, "AddPayment", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Delete)('/:id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Query)('hospital_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Number]),
    __metadata("design:returntype", Promise)
], PharmacyGenerateBillController.prototype, "removePharmacyBill", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Delete)('/deletePayment/:id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Query)('Hospital_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Number]),
    __metadata("design:returntype", Promise)
], PharmacyGenerateBillController.prototype, "removePayment", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/paymentListByBillBasicId/:id'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number]),
    __metadata("design:returntype", void 0)
], PharmacyGenerateBillController.prototype, "paymentsListByBillBasicID", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/getPrescDetailsByprescID/:id'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], PharmacyGenerateBillController.prototype, "getPrescDetailsByprescID", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/getmedicinedetailsByBatchno/:id'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], PharmacyGenerateBillController.prototype, "getmedicinedetailsByBatchno", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], PharmacyGenerateBillController.prototype, "findAll", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/keyword/:search'),
    __param(0, (0, common_1.Param)('search')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], PharmacyGenerateBillController.prototype, "findPharmacyBillByAll", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/getPharmacybillbyID/:id'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], PharmacyGenerateBillController.prototype, "getPharmacybillbyID", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Delete)('/removePharmaBillDetail/:id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Query)('hospital_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Number]),
    __metadata("design:returntype", Promise)
], PharmacyGenerateBillController.prototype, "removePharmaBillDetail", null);
exports.PharmacyGenerateBillController = PharmacyGenerateBillController = __decorate([
    (0, common_1.Controller)('pharmacy-generate-bill'),
    __metadata("design:paramtypes", [pharmacy_generate_bill_service_1.PharmacyGenerateBillService])
], PharmacyGenerateBillController);
//# sourceMappingURL=pharmacy_generate_bill.controller.js.map