import { DataSource } from 'typeorm';
import { Pharmacy } from './entities/pharmacy.entity';
export declare class PharmacyService {
    private readonly connection;
    private readonly dynamicConnection;
    constructor(connection: DataSource, dynamicConnection: DataSource);
    create(createPharmacy: Pharmacy): Promise<{
        'data ': {
            status: string;
            messege: string;
            Added_Pharmacy_Values: any;
        };
    }[]>;
    update(id: number, createPharmacy: Pharmacy): Promise<{
        'data ': {
            status: string;
            messege: string;
            updated_values: any;
        };
    }[]>;
    removePharmacy(id: number, Hospital_id: number): Promise<{
        [key: string]: any;
    }[]>;
    findAll(): Promise<Pharmacy[]>;
    findMedicineStock(search: string): Promise<Pharmacy[]>;
    findPharmacyById(id: number): Promise<Pharmacy>;
    findOne(id: string): Promise<Pharmacy | null>;
    findGoodMedicineStock(id: string): Promise<Pharmacy | null>;
    findBadMedicineStock(id: string): Promise<Pharmacy | null>;
    createBadMedicineStock(createPharmacy: Pharmacy): Promise<{
        'data ': {
            status: string;
            messege: string;
            Added_medicine_bad_stock_Values: any;
        };
    }[]>;
    DeleteBadMedicineStock(id: number, hospital_id: number): Promise<{
        [key: string]: any;
    }[]>;
    removeGoodMedicine(id: number, hospital_id: number): Promise<{
        [key: string]: any;
    }[]>;
}
