"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PatientIdCardService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
let PatientIdCardService = class PatientIdCardService {
    constructor(connection, dynamicConnection) {
        this.connection = connection;
        this.dynamicConnection = dynamicConnection;
    }
    async create(createPatientIdCard) {
        try {
            let patient_ID_Card_id;
            const patient_ID_Card = await this.connection.query(`INSERT into patient_id_card (
     title,
     hospital_name,
     hospital_address,
     background,
     logo,
     sign_image,
     header_color,
     enable_patient_name,
     enable_guardian_name,
     enable_patient_unique_id,
     enable_address,
     enable_phone,
     enable_dob,
     enable_blood_group,
     status
       ) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)`, [createPatientIdCard.title,
                createPatientIdCard.hospital_name,
                createPatientIdCard.hospital_address,
                createPatientIdCard.background,
                createPatientIdCard.logo,
                createPatientIdCard.sign_image,
                createPatientIdCard.header_color,
                createPatientIdCard.enable_patient_name,
                createPatientIdCard.enable_guardian_name,
                createPatientIdCard.enable_patient_unique_id,
                createPatientIdCard.enable_address,
                createPatientIdCard.enable_phone,
                createPatientIdCard.enable_dob,
                createPatientIdCard.enable_blood_group,
                createPatientIdCard.status
            ]);
            patient_ID_Card_id = patient_ID_Card.insertId;
            await this.dynamicConnection.query(`INSERT into patient_id_card (
     title,
     hospital_name,
     hospital_address,
     background,
     logo,
     sign_image,
     header_color,
     enable_patient_name,
     enable_guardian_name,
     enable_patient_unique_id,
     enable_address,
     enable_phone,
     enable_dob,
     enable_blood_group,
     status,
     hospital_id,
     hos_patient_id_card_id
       ) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)`, [createPatientIdCard.title,
                createPatientIdCard.hospital_name,
                createPatientIdCard.hospital_address,
                createPatientIdCard.background,
                createPatientIdCard.logo,
                createPatientIdCard.sign_image,
                createPatientIdCard.header_color,
                createPatientIdCard.enable_patient_name,
                createPatientIdCard.enable_guardian_name,
                createPatientIdCard.enable_patient_unique_id,
                createPatientIdCard.enable_address,
                createPatientIdCard.enable_phone,
                createPatientIdCard.enable_dob,
                createPatientIdCard.enable_blood_group,
                createPatientIdCard.status,
                createPatientIdCard.hospital_id,
                patient_ID_Card_id
            ]);
            return [{
                    "data ": {
                        status: "success",
                        "messege": "Patient ID Card details added successfully ",
                        "Added_Patient_id_card_values": await this.connection.query('SELECT * FROM patient_id_card where id = ?', [patient_ID_Card_id])
                    }
                }];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async updatePatientIdCard(id, createPatientIdCard) {
        try {
            await this.connection.query(`update patient_id_card SET
     title=?,
     hospital_name=?,
     hospital_address=?,
     background=?,
     logo=?,
     sign_image=?,
     header_color=?,
     enable_patient_name=?,
     enable_guardian_name=?,
     enable_patient_unique_id=?,
     enable_address=?,
     enable_phone=?,
     enable_dob=?,
     enable_blood_group=?,
     status=?
     where id=?`, [
                createPatientIdCard.title,
                createPatientIdCard.hospital_name,
                createPatientIdCard.hospital_address,
                createPatientIdCard.background,
                createPatientIdCard.logo,
                createPatientIdCard.sign_image,
                createPatientIdCard.header_color,
                createPatientIdCard.enable_patient_name,
                createPatientIdCard.enable_guardian_name,
                createPatientIdCard.enable_patient_unique_id,
                createPatientIdCard.enable_address,
                createPatientIdCard.enable_phone,
                createPatientIdCard.enable_dob,
                createPatientIdCard.enable_blood_group,
                createPatientIdCard.status,
                id
            ]);
            const dynPatientIDCard = await this.dynamicConnection.query('SELECT id FROM patient_id_card WHERE hos_patient_id_card_id=? and hospital_id=?', [id, createPatientIdCard.hospital_id]);
            const dynPatientIDCardID = dynPatientIDCard[0].id;
            await this.dynamicConnection.query(`update patient_id_card SET
     title=?,
     hospital_name=?,
     hospital_address=?,
     background=?,
     logo=?,
     sign_image=?,
     header_color=?,
     enable_patient_name=?,
     enable_guardian_name=?,
     enable_patient_unique_id=?,
     enable_address=?,
     enable_phone=?,
     enable_dob=?,
     enable_blood_group=?,
     status=?,
     hospital_id=?
     where id=?`, [
                createPatientIdCard.title,
                createPatientIdCard.hospital_name,
                createPatientIdCard.hospital_address,
                createPatientIdCard.background,
                createPatientIdCard.logo,
                createPatientIdCard.sign_image,
                createPatientIdCard.header_color,
                createPatientIdCard.enable_patient_name,
                createPatientIdCard.enable_guardian_name,
                createPatientIdCard.enable_patient_unique_id,
                createPatientIdCard.enable_address,
                createPatientIdCard.enable_phone,
                createPatientIdCard.enable_dob,
                createPatientIdCard.enable_blood_group,
                createPatientIdCard.status,
                createPatientIdCard.hospital_id,
                dynPatientIDCardID
            ]);
            return [{
                    "data ": {
                        status: process.env.SUCCESS_STATUS_V2,
                        "messege": process.env.PATIENT_ID_UPDATED,
                        "updated_values": await this.connection.query('SELECT * FROM patient_id_card WHERE id = ?', [id])
                    }
                }];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async removePatientIDcard(id, hospital_id) {
        try {
            await this.connection.query('DELETE FROM patient_id_card WHERE id = ?', [id]);
            const [GetDynPatientidcard] = await this.dynamicConnection.query('SELECT id FROM patient_id_card WHERE hos_patient_id_card_id=? and hospital_id=?', [id, hospital_id]);
            const GetDynpatientidcardID = GetDynPatientidcard.id;
            await this.dynamicConnection.query('DELETE FROM patient_id_card WHERE id = ?', [GetDynpatientidcardID]);
            return [
                {
                    status: process.env.SUCCESS_STATUS_V2,
                    message: `${process.env.PATIENT_ID} ${id} ${process.env.VISITOR_ASSOCIAT}`,
                },
            ];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
};
exports.PatientIdCardService = PatientIdCardService;
exports.PatientIdCardService = PatientIdCardService = __decorate([
    (0, common_1.Injectable)(),
    __param(1, (0, typeorm_1.InjectDataSource)('AdminConnection')),
    __metadata("design:paramtypes", [typeorm_2.DataSource,
        typeorm_2.DataSource])
], PatientIdCardService);
//# sourceMappingURL=patient_id_card.service.js.map