"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PatientIdCardController = void 0;
const common_1 = require("@nestjs/common");
const patient_id_card_service_1 = require("./patient_id_card.service");
const patient_id_card_entity_1 = require("./entities/patient_id_card.entity");
const auth_guard_1 = require("../auth/auth.guard");
let PatientIdCardController = class PatientIdCardController {
    constructor(patientIdCardService) {
        this.patientIdCardService = patientIdCardService;
    }
    create(createPatientIdCard) {
        return this.patientIdCardService.create(createPatientIdCard);
    }
    updatePatientIdCard(id, createPatientIdCard) {
        return this.patientIdCardService.updatePatientIdCard(id, createPatientIdCard);
    }
    async removePatientIDcard(id, hospital_id) {
        const deletePatientIDcard = await this.patientIdCardService.removePatientIDcard(id, hospital_id);
        return {
            status: 'success',
            message: `id: ${id} deleted successfully`,
        };
    }
};
exports.PatientIdCardController = PatientIdCardController;
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Post)(),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [patient_id_card_entity_1.PatientIdCard]),
    __metadata("design:returntype", void 0)
], PatientIdCardController.prototype, "create", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Patch)('/:id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, patient_id_card_entity_1.PatientIdCard]),
    __metadata("design:returntype", void 0)
], PatientIdCardController.prototype, "updatePatientIdCard", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Delete)('/:id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Query)('hospital_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Number]),
    __metadata("design:returntype", Promise)
], PatientIdCardController.prototype, "removePatientIDcard", null);
exports.PatientIdCardController = PatientIdCardController = __decorate([
    (0, common_1.Controller)('patient-id-card'),
    __metadata("design:paramtypes", [patient_id_card_service_1.PatientIdCardService])
], PatientIdCardController);
//# sourceMappingURL=patient_id_card.controller.js.map