"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PathologyTestController = void 0;
const common_1 = require("@nestjs/common");
const pathology_test_service_1 = require("./pathology_test.service");
const pathology_test_entity_1 = require("./entities/pathology_test.entity");
const auth_guard_1 = require("../auth/auth.guard");
let PathologyTestController = class PathologyTestController {
    constructor(pathologyTestService) {
        this.pathologyTestService = pathologyTestService;
    }
    create(createPathologyTest) {
        return this.pathologyTestService.create(createPathologyTest);
    }
    createpathologyParameterDetails(createPathologyTest) {
        return this.pathologyTestService.createpathologyParameterDetails(createPathologyTest);
    }
    async removePathology(id, hospital_id) {
        await this.pathologyTestService.removePathology(id, hospital_id);
        return {
            status: 'success',
            message: `id: ${id} deleted successfully`,
        };
    }
    updatePathology(id, createPathologyTest) {
        return this.pathologyTestService.updatePathology(id, createPathologyTest);
    }
    async removePathologyparameterdetails(id, hospital_id) {
        await this.pathologyTestService.removePathologyparameterdetails(id, hospital_id);
        return {
            status: 'success',
            message: `id: ${id} deleted successfully`,
        };
    }
    updatePathologyParameterDetails(createPathologyTest) {
        return this.pathologyTestService.updatePathologyParameterDetails(createPathologyTest);
    }
};
exports.PathologyTestController = PathologyTestController;
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Post)(),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [pathology_test_entity_1.PathologyTest]),
    __metadata("design:returntype", void 0)
], PathologyTestController.prototype, "create", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Post)('/pathologyParameterDetails'),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Array]),
    __metadata("design:returntype", void 0)
], PathologyTestController.prototype, "createpathologyParameterDetails", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Delete)('/:id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Query)('hospital_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Number]),
    __metadata("design:returntype", Promise)
], PathologyTestController.prototype, "removePathology", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Patch)('/:id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, pathology_test_entity_1.PathologyTest]),
    __metadata("design:returntype", void 0)
], PathologyTestController.prototype, "updatePathology", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Delete)('/removePathologyparameterdetails/:id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Query)('hospital_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Number]),
    __metadata("design:returntype", Promise)
], PathologyTestController.prototype, "removePathologyparameterdetails", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Patch)('/editpathoparameterdetail/parameter'),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Array]),
    __metadata("design:returntype", void 0)
], PathologyTestController.prototype, "updatePathologyParameterDetails", null);
exports.PathologyTestController = PathologyTestController = __decorate([
    (0, common_1.Controller)('pathology-test'),
    __metadata("design:paramtypes", [pathology_test_service_1.PathologyTestService])
], PathologyTestController);
//# sourceMappingURL=pathology_test.controller.js.map