"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.OperationIpdController = void 0;
const common_1 = require("@nestjs/common");
const operation_ipd_entity_1 = require("./entities/operation_ipd.entity");
const operation_ipd_service_1 = require("./operation_ipd.service");
const auth_guard_1 = require("../auth/auth.guard");
let OperationIpdController = class OperationIpdController {
    constructor(operationIpdService) {
        this.operationIpdService = operationIpdService;
    }
    create(createOperationIpd) {
        return this.operationIpdService.create(createOperationIpd);
    }
    update(id, createOperationIpd) {
        return this.operationIpdService.update(id, createOperationIpd);
    }
    async removeNurseNoteComment(id, Hospital_id) {
        await this.operationIpdService.remove(id, Hospital_id);
        return {
            status: 'success',
            message: `id: ${id} deleted successfully`,
        };
    }
    findIPDOperSearch(id, search) {
        return this.operationIpdService.findIPDOperSearch(id, search);
    }
    findopernamebycategory(id) {
        return this.operationIpdService.findopernamebycategory(id);
    }
};
exports.OperationIpdController = OperationIpdController;
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Post)(),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [operation_ipd_entity_1.OperationIpd]),
    __metadata("design:returntype", void 0)
], OperationIpdController.prototype, "create", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Patch)('/:id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, operation_ipd_entity_1.OperationIpd]),
    __metadata("design:returntype", void 0)
], OperationIpdController.prototype, "update", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Delete)('/deleteOperation/:id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Query)('Hospital_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Number]),
    __metadata("design:returntype", Promise)
], OperationIpdController.prototype, "removeNurseNoteComment", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/OperationByIPDid/:id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Query)('search')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, String]),
    __metadata("design:returntype", void 0)
], OperationIpdController.prototype, "findIPDOperSearch", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/internal/operationName/:id'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number]),
    __metadata("design:returntype", void 0)
], OperationIpdController.prototype, "findopernamebycategory", null);
exports.OperationIpdController = OperationIpdController = __decorate([
    (0, common_1.Controller)('operation-ipd'),
    __metadata("design:paramtypes", [operation_ipd_service_1.OperationIpdService])
], OperationIpdController);
//# sourceMappingURL=operation_ipd.controller.js.map