"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.OpdVoiceDateService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
let OpdVoiceDateService = class OpdVoiceDateService {
    constructor(connection, dynamicConnection) {
        this.connection = connection;
        this.dynamicConnection = dynamicConnection;
    }
    async create(createOpdVoiceDateDto) {
        try {
            const result = await this.dynamicConnection.query(`
      INSERT into opd_voice_data (aayush_unique_id,user_id,type,transcript_id,opd_details_id,data,
      audio_file, hospital_id) VALUES (?,?,?,?,?,?,?,?)`, [
                createOpdVoiceDateDto.aayush_unique_id,
                createOpdVoiceDateDto.user_id,
                createOpdVoiceDateDto.type,
                createOpdVoiceDateDto.transcript_id,
                createOpdVoiceDateDto.opd_details_id,
                JSON.stringify(createOpdVoiceDateDto.data),
                createOpdVoiceDateDto.audio_file,
                createOpdVoiceDateDto.hospital_id,
            ]);
            return {
                success: result.affectedRows > 0,
                id: result.insertId,
                message: 'Record created successfully',
            };
        }
        catch (error) {
            console.error('Error inserting opd_voice_data:', error);
            throw new common_1.HttpException({
                responseCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findOne(id, hospital_id) {
        const voice_data = await this.dynamicConnection.query(`SELECT * FROM opd_voice_data where opd_details_id = ? and hospital_id = ?`, [id, hospital_id]);
        if (voice_data.length === 0) {
            throw new common_1.HttpException({
                responseCode: common_1.HttpStatus.NOT_FOUND,
                message: 'Record not found',
            }, common_1.HttpStatus.NOT_FOUND);
        }
        try {
            return voice_data[0];
        }
        catch (error) {
            throw new common_1.HttpException({
                responseCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async update(id, updateOpdVoiceDateDto) {
        const result = await this.dynamicConnection.query(`
      UPDATE opd_voice_data SET aayush_unique_id = ?, user_id = ?, type = ?, transcript_id = ?, opd_details_id = ?, data = ?, audio_file = ?, hospital_id = ? WHERE id = ?`, [
            updateOpdVoiceDateDto.aayush_unique_id,
            updateOpdVoiceDateDto.user_id,
            updateOpdVoiceDateDto.type,
            updateOpdVoiceDateDto.transcript_id,
            updateOpdVoiceDateDto.opd_details_id,
            JSON.stringify(updateOpdVoiceDateDto.data),
            updateOpdVoiceDateDto.audio_file,
            updateOpdVoiceDateDto.hospital_id,
            id,
        ]);
        if (result.affectedRows === 0) {
            throw new common_1.HttpException({
                responseCode: common_1.HttpStatus.NOT_FOUND,
                message: 'Record not found',
            }, common_1.HttpStatus.NOT_FOUND);
        }
        try {
            return result;
        }
        catch (error) {
            console.error('Error updating opd_voice_data:', error);
            throw new common_1.HttpException({
                responseCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async hoscreate(createOpdVoiceDateDto) {
        const hos_opd = await this.dynamicConnection.query(`select id from opd_details where hos_opd_id = ? and Hospital_id = ?`, [createOpdVoiceDateDto.opd_details_id, createOpdVoiceDateDto.hospital_id]);
        if (hos_opd.length === 0) {
            throw new common_1.HttpException({
                responseCode: common_1.HttpStatus.NOT_FOUND,
                message: 'Record not found',
            }, common_1.HttpStatus.NOT_FOUND);
        }
        try {
            const result = await this.dynamicConnection.query(`
      INSERT into opd_voice_data (aayush_unique_id,user_id,type,transcript_id,opd_details_id,data,
      audio_file, hospital_id) VALUES (?,?,?,?,?,?,?,?)`, [
                createOpdVoiceDateDto.aayush_unique_id,
                createOpdVoiceDateDto.user_id,
                createOpdVoiceDateDto.type,
                createOpdVoiceDateDto.transcript_id,
                hos_opd[0].id,
                JSON.stringify(createOpdVoiceDateDto.data),
                createOpdVoiceDateDto.audio_file,
                createOpdVoiceDateDto.hospital_id,
            ]);
            return {
                success: result.affectedRows > 0,
                id: result.insertId,
                message: 'Record created successfully',
            };
        }
        catch (error) {
            console.error('Error inserting opd_voice_data:', error);
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async hosFindOne(id, hospital_id) {
        const hos_opd = await this.dynamicConnection.query(`select id from opd_details where hos_opd_id = ? and Hospital_id = ?`, [id, hospital_id]);
        if (hos_opd.length === 0) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.NOT_FOUND,
                message: 'Record not found',
            }, common_1.HttpStatus.NOT_FOUND);
        }
        try {
            const voice_data = await this.dynamicConnection.query(`SELECT * FROM opd_voice_data where opd_details_id = ? and hospital_id = ?`, [hos_opd[0].id, hospital_id]);
            const doctor_name = await this.dynamicConnection.query(`select CONCAT(staff.name, ' ', staff.surname, '(', staff.id, ')') AS doctor, visit_details.appointment_date from opd_details
        left join  visit_details on visit_details.opd_details_id = opd_details.id
        left join staff on visit_details.cons_doctor = staff.id where opd_details.hos_opd_id = ? and opd_details.Hospital_id = ?`, [id, hospital_id]);
            let data = {
                details: doctor_name,
                voice_data: voice_data[0],
            };
            return data;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async hosupdate(id, updateOpdVoiceDateDto) {
        const hos_opd = await this.dynamicConnection.query(`select id from opd_details where hos_opd_id = ? and Hospital_id = ?`, [updateOpdVoiceDateDto.opd_details_id, updateOpdVoiceDateDto.hospital_id]);
        if (hos_opd.length === 0) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.NOT_FOUND,
                message: 'Record not found',
            }, common_1.HttpStatus.NOT_FOUND);
        }
        try {
            const result = await this.dynamicConnection.query(`
      UPDATE opd_voice_data SET aayush_unique_id = ?, user_id = ?, type = ?, transcript_id = ?, opd_details_id = ?, data = ?, audio_file = ?, hospital_id = ? WHERE id = ?`, [
                updateOpdVoiceDateDto.aayush_unique_id,
                updateOpdVoiceDateDto.user_id,
                updateOpdVoiceDateDto.type,
                updateOpdVoiceDateDto.transcript_id,
                hos_opd[0].id,
                JSON.stringify(updateOpdVoiceDateDto.data),
                updateOpdVoiceDateDto.audio_file,
                updateOpdVoiceDateDto.hospital_id,
                id,
            ]);
            return result;
        }
        catch (error) {
            console.error('Error updating opd_voice_data:', error);
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
};
exports.OpdVoiceDateService = OpdVoiceDateService;
exports.OpdVoiceDateService = OpdVoiceDateService = __decorate([
    (0, common_1.Injectable)(),
    __param(1, (0, typeorm_1.InjectDataSource)('AdminConnection')),
    __metadata("design:paramtypes", [typeorm_2.DataSource,
        typeorm_2.DataSource])
], OpdVoiceDateService);
//# sourceMappingURL=opd_voice_date.service.js.map