"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.OpdVoiceDateController = void 0;
const common_1 = require("@nestjs/common");
const opd_voice_date_service_1 = require("./opd_voice_date.service");
const opd_voice_date_entity_1 = require("./entities/opd_voice_date.entity");
const auth_guard_1 = require("../auth/auth.guard");
let OpdVoiceDateController = class OpdVoiceDateController {
    constructor(opdVoiceDateService) {
        this.opdVoiceDateService = opdVoiceDateService;
    }
    async create(createOpdVoiceDateDto) {
        const res = await this.opdVoiceDateService.create(createOpdVoiceDateDto);
        return {
            responseCode: 200,
            responseMessage: 'Record created successfully',
            data: res,
        };
    }
    async findOne(id, hospital_id) {
        const res = await this.opdVoiceDateService.findOne(id, hospital_id);
        return {
            responseCode: 200,
            responseMessage: 'Record found successfully',
            data: res,
        };
    }
    async update(id, updateOpdVoiceDateDto) {
        const res = await this.opdVoiceDateService.update(id, updateOpdVoiceDateDto);
        return {
            responseCode: 200,
            responseMessage: 'Record updated successfully',
            data: {
                voiceId: id,
            },
        };
    }
    async hoscreate(createOpdVoiceDateDto) {
        const res = await this.opdVoiceDateService.hoscreate(createOpdVoiceDateDto);
        return {
            responseCode: 200,
            responseMessage: 'Record created successfully',
            data: {
                voiceId: res,
            },
        };
    }
    async hosFindOne(id, hospital_id) {
        const res = await this.opdVoiceDateService.hosFindOne(id, hospital_id);
        return {
            responseCode: 200,
            responseMessage: 'Record found successfully',
            details: res.details[0],
            data: res.voice_data,
        };
    }
    async hosupdate(id, updateOpdVoiceDateDto) {
        const res = await this.opdVoiceDateService.hosupdate(id, updateOpdVoiceDateDto);
        return {
            responseCode: 200,
            responseMessage: 'Record updated successfully',
            data: {
                voiceId: id,
            },
        };
    }
};
exports.OpdVoiceDateController = OpdVoiceDateController;
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Post)('/admin'),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [opd_voice_date_entity_1.OpdVoiceDate]),
    __metadata("design:returntype", Promise)
], OpdVoiceDateController.prototype, "create", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/admin/:id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Query)('hospital_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Number]),
    __metadata("design:returntype", Promise)
], OpdVoiceDateController.prototype, "findOne", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Patch)('/admin/:id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, opd_voice_date_entity_1.OpdVoiceDate]),
    __metadata("design:returntype", Promise)
], OpdVoiceDateController.prototype, "update", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Post)('/hospital'),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [opd_voice_date_entity_1.OpdVoiceDate]),
    __metadata("design:returntype", Promise)
], OpdVoiceDateController.prototype, "hoscreate", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/hospital/:id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Query)('hospital_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Number]),
    __metadata("design:returntype", Promise)
], OpdVoiceDateController.prototype, "hosFindOne", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Patch)('/hospital/:id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, opd_voice_date_entity_1.OpdVoiceDate]),
    __metadata("design:returntype", Promise)
], OpdVoiceDateController.prototype, "hosupdate", null);
exports.OpdVoiceDateController = OpdVoiceDateController = __decorate([
    (0, common_1.Controller)('opd-voice-date'),
    __metadata("design:paramtypes", [opd_voice_date_service_1.OpdVoiceDateService])
], OpdVoiceDateController);
//# sourceMappingURL=opd_voice_date.controller.js.map