"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.OpdBillingController = void 0;
const common_1 = require("@nestjs/common");
const opd_billing_service_1 = require("./opd_billing.service");
const opd_billing_entity_1 = require("./entities/opd_billing.entity");
const auth_guard_1 = require("../auth/auth.guard");
let OpdBillingController = class OpdBillingController {
    constructor(opdBillingService) {
        this.opdBillingService = opdBillingService;
    }
    create(createOpdBilling) {
        return this.opdBillingService.create(createOpdBilling);
    }
    AddOPDPayment(createOpdBilling) {
        return this.opdBillingService.AddOPDPayment(createOpdBilling);
    }
    AddIPDPayment(createOpdBilling) {
        return this.opdBillingService.AddIPDPayment(createOpdBilling);
    }
    AddOPDPaymentv3(createOpdBilling) {
        if (!createOpdBilling.received_by) {
            return {
                status_code: process.env.ERROR_STATUS_CODE_PARAMS_MISSING_V2,
                status: process.env.ERROR_STATUS,
                message: process.env.ERROR_STATUS_CODE_PARAMS_MISSING_V2,
            };
        }
        if (!createOpdBilling.payment_method) {
            return {
                status_code: process.env.ERROR_STATUS_CODE_PARAMS_MISSING_V2,
                status: process.env.ERROR_STATUS,
                message: process.env.ERROR_MESSAGE_PARAM_MISSING,
            };
        }
        if (createOpdBilling.payment_mode.toLocaleLowerCase() == 'card' &&
            !createOpdBilling.card_division &&
            !createOpdBilling.card_bank_name &&
            !createOpdBilling.card_type &&
            !createOpdBilling.card_transaction_id) {
            return {
                status_code: process.env.ERROR_STATUS_CODE_PARAMS_MISSING_V2,
                status: process.env.ERROR_STATUS,
                message: process.env.ERROR_MESSAGE_PARAM_MISSING,
            };
        }
        if (createOpdBilling.payment_mode.toLocaleLowerCase() == 'net_banking' &&
            !createOpdBilling.net_banking_division &&
            !createOpdBilling.net_banking_transaction_id) {
            return {
                status_code: process.env.ERROR_STATUS_CODE_PARAMS_MISSING_V2,
                status: process.env.ERROR_STATUS,
                message: process.env.ERROR_MESSAGE_PARAM_MISSING,
            };
        }
        if (createOpdBilling.payment_mode.toLocaleLowerCase() == 'upi' &&
            !createOpdBilling.upi_id &&
            !createOpdBilling.upi_transaction_id &&
            !createOpdBilling.upi_bank_name) {
            return {
                status_code: process.env.ERROR_STATUS_CODE_PARAMS_MISSING_V2,
                status: process.env.ERROR_STATUS,
                message: process.env.ERROR_MESSAGE_PARAM_MISSING,
            };
        }
        return this.opdBillingService.AddOPDPaymentV3(createOpdBilling);
    }
    AddIPDPaymentv3(createOpdBilling) {
        if (!createOpdBilling.received_by) {
            return {
                status_code: process.env.ERROR_STATUS_CODE_PARAMS_MISSING_V2,
                status: process.env.ERROR_STATUS,
                message: process.env.ERROR_STATUS_CODE_PARAMS_MISSING_V2,
            };
        }
        if (!createOpdBilling.payment_method) {
            return {
                status_code: process.env.ERROR_STATUS_CODE_PARAMS_MISSING_V2,
                status: process.env.ERROR_STATUS,
                message: process.env.ERROR_MESSAGE_PARAM_MISSING,
            };
        }
        if (createOpdBilling.payment_mode.toLocaleLowerCase() == 'card' &&
            !createOpdBilling.card_division &&
            !createOpdBilling.card_bank_name &&
            !createOpdBilling.card_type &&
            !createOpdBilling.card_transaction_id) {
            return {
                status_code: process.env.ERROR_STATUS_CODE_PARAMS_MISSING_V2,
                status: process.env.ERROR_STATUS,
                message: process.env.ERROR_MESSAGE_PARAM_MISSING,
            };
        }
        if (createOpdBilling.payment_mode.toLocaleLowerCase() == 'net_banking' &&
            !createOpdBilling.net_banking_division &&
            !createOpdBilling.net_banking_transaction_id) {
            return {
                status_code: process.env.ERROR_STATUS_CODE_PARAMS_MISSING_V2,
                status: process.env.ERROR_STATUS,
                message: process.env.ERROR_MESSAGE_PARAM_MISSING,
            };
        }
        if (createOpdBilling.payment_mode.toLocaleLowerCase() == 'upi' &&
            !createOpdBilling.upi_id &&
            !createOpdBilling.upi_transaction_id &&
            !createOpdBilling.upi_bank_name) {
            return {
                status_code: process.env.ERROR_STATUS_CODE_PARAMS_MISSING_V2,
                status: process.env.ERROR_STATUS,
                message: process.env.ERROR_MESSAGE_PARAM_MISSING,
            };
        }
        return this.opdBillingService.AddIPDPaymentV3(createOpdBilling);
    }
};
exports.OpdBillingController = OpdBillingController;
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Post)(),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [opd_billing_entity_1.OpdBilling]),
    __metadata("design:returntype", void 0)
], OpdBillingController.prototype, "create", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Post)('/AddOPDPayment'),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [opd_billing_entity_1.OpdBilling]),
    __metadata("design:returntype", void 0)
], OpdBillingController.prototype, "AddOPDPayment", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Post)('/AddIPDPayment'),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [opd_billing_entity_1.OpdBilling]),
    __metadata("design:returntype", void 0)
], OpdBillingController.prototype, "AddIPDPayment", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Post)('/AddOPDPayment/v3'),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [opd_billing_entity_1.OpdBillingV3]),
    __metadata("design:returntype", void 0)
], OpdBillingController.prototype, "AddOPDPaymentv3", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Post)('/AddIPDPayment/v3'),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [opd_billing_entity_1.OpdBillingV3]),
    __metadata("design:returntype", void 0)
], OpdBillingController.prototype, "AddIPDPaymentv3", null);
exports.OpdBillingController = OpdBillingController = __decorate([
    (0, common_1.Controller)('opd-billing'),
    __metadata("design:paramtypes", [opd_billing_service_1.OpdBillingService])
], OpdBillingController);
//# sourceMappingURL=opd_billing.controller.js.map