"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.OpdOutPatientController = void 0;
const common_1 = require("@nestjs/common");
const opd_out_patient_service_1 = require("./opd-out_patient.service");
const opd_out_patient_entity_1 = require("./entities/opd-out_patient.entity");
const auth_guard_1 = require("../auth/auth.guard");
let OpdOutPatientController = class OpdOutPatientController {
    constructor(opdOutPatientService) {
        this.opdOutPatientService = opdOutPatientService;
    }
    create(opd_entity) {
        return this.opdOutPatientService.create(opd_entity);
    }
    findAll() {
        return this.opdOutPatientService.findAll();
    }
    findOne(search) {
        return this.opdOutPatientService.findOne(search);
    }
    update(id, opd_entity) {
        return this.opdOutPatientService.update(+id, opd_entity);
    }
    remove(id, hos_id) {
        return this.opdOutPatientService.remove(id, hos_id);
    }
    findTitleByType(id) {
        return this.opdOutPatientService.findTitleByType(id);
    }
    findDescriptionbytitle(id) {
        return this.opdOutPatientService.findDescByOne(id);
    }
    findOpdDetailsBySearch(search) {
        return this.opdOutPatientService.findOpdDetailsBySearch(search);
    }
    async findAllopd(limit, page, search) {
        try {
            const final_output = await this.opdOutPatientService.findopd_details(limit || 10, page || 1, search);
            if (final_output.details.length > 0) {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE,
                    status: process.env.SUCCESS_STATUS,
                    message: process.env.SUCCESS_MESSAGE,
                    data: final_output.details,
                    total: final_output.total,
                    limit: final_output.limit,
                    totalPages: Math.ceil(final_output.total / final_output.limit),
                };
            }
            else {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE,
                    status: process.env.SUCCESS_STATUS,
                    message: 'No opd found',
                    data: [],
                    total: 0,
                    limit: limit,
                    page: page,
                    totalPages: 0,
                };
            }
        }
        catch (error) {
            return {
                status_code: process.env.ERROR_STATUS_CODE,
                status: process.env.ERROR_STATUS,
                message: process.env.ERROR_MESSAGE,
            };
        }
    }
    async V3findAllopd(limit, page, search) {
        try {
            const final_output = await this.opdOutPatientService.V3findopd_details(limit || 10, page || 1, search);
            if (final_output.details.length > 0) {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE,
                    status: process.env.SUCCESS_STATUS,
                    message: process.env.SUCCESS_MESSAGE,
                    data: final_output.details,
                    total: final_output.count,
                };
            }
            else {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE,
                    status: process.env.SUCCESS_STATUS,
                    message: 'No opd found',
                    data: [],
                    total: 0,
                };
            }
        }
        catch (error) {
            return {
                status_code: process.env.ERROR_STATUS_CODE,
                status: process.env.ERROR_STATUS,
                message: process.env.ERROR_MESSAGE,
            };
        }
    }
    findOnebyid(id, hospital_id) {
        return this.opdOutPatientService.findOnebyid(id, hospital_id);
    }
};
exports.OpdOutPatientController = OpdOutPatientController;
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Post)(),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [opd_out_patient_entity_1.OpdOutPatient]),
    __metadata("design:returntype", void 0)
], OpdOutPatientController.prototype, "create", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], OpdOutPatientController.prototype, "findAll", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/one'),
    __param(0, (0, common_1.Query)('search')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], OpdOutPatientController.prototype, "findOne", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Patch)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, opd_out_patient_entity_1.OpdOutPatient]),
    __metadata("design:returntype", void 0)
], OpdOutPatientController.prototype, "update", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Delete)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Query)('hos_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Number]),
    __metadata("design:returntype", void 0)
], OpdOutPatientController.prototype, "remove", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/symptoms/:id'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number]),
    __metadata("design:returntype", void 0)
], OpdOutPatientController.prototype, "findTitleByType", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/symptomDescription/:id'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number]),
    __metadata("design:returntype", void 0)
], OpdOutPatientController.prototype, "findDescriptionbytitle", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/opdDetails/:search'),
    __param(0, (0, common_1.Param)('search')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], OpdOutPatientController.prototype, "findOpdDetailsBySearch", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/v2/getAllpage/opd'),
    __param(0, (0, common_1.Query)('limit')),
    __param(1, (0, common_1.Query)('page')),
    __param(2, (0, common_1.Query)('search')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Number, String]),
    __metadata("design:returntype", Promise)
], OpdOutPatientController.prototype, "findAllopd", null);
__decorate([
    (0, common_1.Get)('/v3/getAllpage/opd'),
    __param(0, (0, common_1.Query)('limit')),
    __param(1, (0, common_1.Query)('page')),
    __param(2, (0, common_1.Query)('search')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Number, String]),
    __metadata("design:returntype", Promise)
], OpdOutPatientController.prototype, "V3findAllopd", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Query)('hospital_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Number]),
    __metadata("design:returntype", void 0)
], OpdOutPatientController.prototype, "findOnebyid", null);
exports.OpdOutPatientController = OpdOutPatientController = __decorate([
    (0, common_1.Controller)('opd-out-patient'),
    __metadata("design:paramtypes", [opd_out_patient_service_1.OpdOutPatientService])
], OpdOutPatientController);
//# sourceMappingURL=opd-out_patient.controller.js.map