"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.OpdOperationService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
let OpdOperationService = class OpdOperationService {
    constructor(connection, dynamicConnection) {
        this.connection = connection;
        this.dynamicConnection = dynamicConnection;
    }
    async create(operation_opd) {
        try {
            const [staffId] = await this.connection.query('SELECT email FROM staff WHERE id = ?', [operation_opd.consultant_doctor]);
            if (!staffId || staffId.length === 0) {
                throw new Error(`Staff with id: ${operation_opd.consultant_doctor} not found.`);
            }
            const docemail = staffId.email;
            const opdoperation = await this.connection.query(`INSERT into operation_theatre (
          opd_details_id,
          operation_id,
          date,
          consultant_doctor,
          ass_consultant_1,
          ass_consultant_2,
          anesthetist,
          anaethesia_type,
          ot_technician,
          ot_assistant,
          result,
          remark
        ) VALUES (?,?,?,?,?,?,?,?,?,?,?,?)`, [
                operation_opd.opd_details_id,
                operation_opd.operation_id,
                operation_opd.date,
                operation_opd.consultant_doctor,
                operation_opd.ass_consultant_1,
                operation_opd.ass_consultant_2,
                operation_opd.anesthetist,
                operation_opd.anaethesia_type,
                operation_opd.ot_technician,
                operation_opd.ot_assistant,
                operation_opd.result,
                operation_opd.remark
            ]);
            const opdoperationid = opdoperation.insertId;
            const dynnnopdd = await this.dynamicConnection.query('SELECT id FROM opd_details WHERE hos_opd_id = ?', [operation_opd.opd_details_id]);
            const Yourdynnnopdd = dynnnopdd[0].id;
            const dynOperationidd = await this.dynamicConnection.query('SELECT id FROM operation WHERE hospital_operation_id = ?', [operation_opd.operation_id]);
            const Yourdynnnoperid = dynOperationidd[0].id;
            const dynamicUpdateStaff = await this.dynamicConnection.query('SELECT id FROM staff WHERE email = ?', [docemail]);
            const dynamicUPTDStaffId = dynamicUpdateStaff[0].id;
            await this.dynamicConnection.query(`INSERT into operation_theatre (
            opd_details_id,
          operation_id,
          date,
          consultant_doctor,
          ass_consultant_1,
          ass_consultant_2,
          anesthetist,
          anaethesia_type,
          ot_technician,
          ot_assistant,
          result,
          remark,
          Hospital_id,
          hos_operation_theatre_id
        ) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?)`, [
                Yourdynnnopdd,
                Yourdynnnoperid,
                operation_opd.date,
                dynamicUPTDStaffId,
                operation_opd.ass_consultant_1,
                operation_opd.ass_consultant_2,
                operation_opd.anesthetist,
                operation_opd.anaethesia_type,
                operation_opd.ot_technician,
                operation_opd.ot_assistant,
                operation_opd.result,
                operation_opd.remark,
                operation_opd.Hospital_id,
                opdoperationid
            ]);
            return [{
                    "data ": {
                        status: process.env.SUCCESS_STATUS_V2,
                        messege: process.env.OPD_OPERATION,
                        "Added_opd_operation_Values": await this.connection.query('SELECT * FROM operation_theatre WHERE id = ?', [opdoperationid])
                    }
                }];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findALL() {
        try {
            const opd_operation = await this.connection.query(`select operation_theatre.id,concat("OTRN",operation_theatre.id) as reference_no, operation_theatre.date as date, staff.name as consultant_doctor,
        operation_theatre.ass_consultant_2 as Assistant_consultant_2,
       operation_theatre.anaethesia_type as anaethesia_type, operation_theatre.ot_assistant as OT_assistant, operation_theatre.result,
       operation.operation as operation_name,operation_category.category as Operation_category ,operation_theatre.ass_consultant_1 as ass_consultant_1,
       operation_theatre.anesthetist as anesthetist ,operation_theatre.ot_technician as OT_technician ,
       operation_theatre.remark from
        operation_theatre 
       left join operation on operation_theatre.operation_id = operation.id 
       left join operation_category on operation.category_id = operation_category.id
       left join staff on operation_theatre.consultant_doctor = staff.id`);
            return opd_operation;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findone(opd_details_id, operation_theatre_id) {
        try {
            const opd_operation = await this.connection.query(`select concat("OTRN",operation_theatre.id) as reference_no, operation_theatre.date as date, staff.name as consultant_doctor,
        operation_theatre.ass_consultant_2 as Assistant_consultant_2,
       operation_theatre.anaethesia_type as anaethesia_type, operation_theatre.ot_assistant as OT_assistant, operation_theatre.result,
       operation.operation as operation_name,operation_category.category as Operation_category ,operation_theatre.ass_consultant_1 as ass_consultant_1,
       operation_theatre.anesthetist as anesthetist ,operation_theatre.ot_technician as OT_technician ,
       operation_theatre.remark from
        operation_theatre 
       left join operation on operation_theatre.operation_id = operation.id 
       left join operation_category on operation.category_id = operation_category.id
       left join staff on operation_theatre.consultant_doctor = staff.id where opd_details_id = ? and operation_theatre.id = ?`, [opd_details_id, operation_theatre_id]);
            return opd_operation;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findOPDOperSearch(id, search) {
        try {
            let query = `SELECT concat('OTRN',"",operation_theatre.id) AS ReferenceNo,
        operation_theatre.date AS OperationDate,
        operation.operation AS OperationName,
        operation_category.category AS OperationCategory,
        operation_theatre.ot_technician AS OTTechnician
        from operation_theatre
        LEFT JOIN operation ON operation_theatre.operation_id = operation.id
        LEFT JOIN operation_category ON operation.category_id = operation_category.id
        WHERE operation_theatre.opd_details_id = ?`;
            let values = [];
            values.push(id);
            if (search) {
                query += `  and (concat('OTRN',"",operation_theatre.id) like ? or operation_theatre.date like ? or operation.operation like ? or operation_category.category like ? or operation_theatre.ot_technician like ?)  `;
                values.push("%" + search + "%");
                values.push("%" + search + "%");
                values.push("%" + search + "%");
                values.push("%" + search + "%");
                values.push("%" + search + "%");
            }
            const getOperationOPDsch = await this.connection.query(query, values);
            return getOperationOPDsch;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findopernamebycategory(id) {
        try {
            const getOperationname = await this.connection.query(`SELECT * from operation where category_id = ?`, [id]);
            if (getOperationname.length === 1) {
                return getOperationname;
            }
            else {
                return null;
            }
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async update(id, createoperationopd) {
        try {
            const [staffId] = await this.connection.query('SELECT email FROM staff WHERE id = ?', [createoperationopd.consultant_doctor]);
            if (!staffId || staffId.length === 0) {
                throw new Error(`Staff with id: ${createoperationopd.consultant_doctor} not found.`);
            }
            const docemail = staffId.email;
            const opdoperationopdidd = await this.connection.query(`SELECT opd_details_id from operation_theatre WHERE id = ?`, [id]);
            const operationopdiddddd = opdoperationopdidd[0].opd_details_id;
            await this.connection.query(`UPDATE operation_theatre SET
        opd_details_id =?,
          operation_id=?,
          date=?,
          consultant_doctor=?,
          ass_consultant_1=?,
          ass_consultant_2=?,
          anesthetist=?,
          anaethesia_type=?,
          ot_technician=?,
          ot_assistant=?,
          result=?,
          remark=?
          WHERE id = ?
        `, [
                operationopdiddddd,
                createoperationopd.operation_id,
                createoperationopd.date,
                createoperationopd.consultant_doctor,
                createoperationopd.ass_consultant_1,
                createoperationopd.ass_consultant_2,
                createoperationopd.anesthetist,
                createoperationopd.anaethesia_type,
                createoperationopd.ot_technician,
                createoperationopd.ot_assistant,
                createoperationopd.result,
                createoperationopd.remark,
                id
            ]);
            const dynnnopdd = await this.dynamicConnection.query('SELECT id FROM opd_details WHERE hos_opd_id = ?', [operationopdiddddd]);
            const Yourdynnnopdd = dynnnopdd[0].id;
            const operdynopdidd = await this.dynamicConnection.query(`SELECT id from operation_theatre WHERE hos_operation_theatre_id = ? and Hospital_id = ?`, [id, createoperationopd.Hospital_id]);
            const operdynnipdoddddd = operdynopdidd[0].id;
            const dynOperationidd = await this.dynamicConnection.query('SELECT id FROM operation WHERE hospital_operation_id = ?', [createoperationopd.operation_id]);
            const Yourdynnnoperid = dynOperationidd[0].id;
            const dynamicUpdateStaff = await this.dynamicConnection.query('SELECT id FROM staff WHERE email = ?', [docemail]);
            const dynamicUPTDStaffId = dynamicUpdateStaff[0].id;
            await this.dynamicConnection.query(`UPDATE operation_theatre SET
        opd_details_id=?,
          operation_id=?,
          date=?,
          consultant_doctor=?,
          ass_consultant_1=?,
          ass_consultant_2=?,
          anesthetist=?,
          anaethesia_type=?,
          ot_technician=?,
          ot_assistant=?,
          result=?,
          remark=?,
          Hospital_id=?
          WHERE id = ?
        `, [
                Yourdynnnopdd,
                Yourdynnnoperid,
                createoperationopd.date,
                dynamicUPTDStaffId,
                createoperationopd.ass_consultant_1,
                createoperationopd.ass_consultant_2,
                createoperationopd.anesthetist,
                createoperationopd.anaethesia_type,
                createoperationopd.ot_technician,
                createoperationopd.ot_assistant,
                createoperationopd.result,
                createoperationopd.remark,
                createoperationopd.Hospital_id,
                operdynnipdoddddd
            ]);
            return [{
                    "data ": {
                        status: process.env.SUCCESS_STATUS_V2,
                        "messege": process.env.OPD_OPERATION_UPDATED,
                        "Updated_opd_operation_Values": await this.connection.query('SELECT * FROM operation_theatre WHERE id = ?', [id])
                    }
                }];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async remove(id, Hospital_id) {
        try {
            await this.connection.query('DELETE FROM operation_theatre WHERE id = ?', [id]);
            const dynamicDeletedoperationn = await this.dynamicConnection.query('SELECT id FROM operation_theatre WHERE hos_operation_theatre_id= ?', [id]);
            const dynamicDeleteOperationId = dynamicDeletedoperationn[0].id;
            await this.dynamicConnection.query('DELETE FROM operation_theatre WHERE id = ? AND Hospital_id = ?', [dynamicDeleteOperationId, Hospital_id]);
            return [
                {
                    status: process.env.SUCCESS_STATUS_V2,
                    message: process.env.DELETED
                },
            ];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
};
exports.OpdOperationService = OpdOperationService;
exports.OpdOperationService = OpdOperationService = __decorate([
    (0, common_1.Injectable)(),
    __param(1, (0, typeorm_1.InjectDataSource)('AdminConnection')),
    __metadata("design:paramtypes", [typeorm_2.DataSource,
        typeorm_2.DataSource])
], OpdOperationService);
//# sourceMappingURL=opd-operation.service.js.map