"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.OpdOperationController = void 0;
const common_1 = require("@nestjs/common");
const opd_operation_service_1 = require("./opd-operation.service");
const opd_operation_entity_1 = require("./entities/opd-operation.entity");
const auth_guard_1 = require("../auth/auth.guard");
let OpdOperationController = class OpdOperationController {
    constructor(opdOperationService) {
        this.opdOperationService = opdOperationService;
    }
    create(createOperationopd) {
        return this.opdOperationService.create(createOperationopd);
    }
    findALL() {
        return this.opdOperationService.findALL();
    }
    findone(opd_details_id, operation_theatre_id) {
        return this.opdOperationService.findone(opd_details_id, operation_theatre_id);
    }
    findIPDOperSearch(id, search) {
        return this.opdOperationService.findOPDOperSearch(id, search);
    }
    findopernamebycategory(id) {
        return this.opdOperationService.findopernamebycategory(id);
    }
    update(id, createOperationopd) {
        return this.opdOperationService.update(id, createOperationopd);
    }
    async removeNurseNoteComment(id, Hospital_id) {
        const deleteOperation = await this.opdOperationService.remove(id, Hospital_id);
        return {
            status: 'success',
            message: `id: ${id} deleted successfully`,
        };
    }
};
exports.OpdOperationController = OpdOperationController;
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Post)(),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [opd_operation_entity_1.OpdOperation]),
    __metadata("design:returntype", void 0)
], OpdOperationController.prototype, "create", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], OpdOperationController.prototype, "findALL", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/operations'),
    __param(0, (0, common_1.Query)(`opd_details_id`)),
    __param(1, (0, common_1.Query)(`operation_theatre_id`)),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Number]),
    __metadata("design:returntype", void 0)
], OpdOperationController.prototype, "findone", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/OperationByOPDid/:id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Query)('search')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, String]),
    __metadata("design:returntype", void 0)
], OpdOperationController.prototype, "findIPDOperSearch", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/operationName/:id'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number]),
    __metadata("design:returntype", void 0)
], OpdOperationController.prototype, "findopernamebycategory", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Patch)('/:id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, opd_operation_entity_1.OpdOperation]),
    __metadata("design:returntype", void 0)
], OpdOperationController.prototype, "update", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Delete)('/deleteOperation/:id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Query)('Hospital_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Number]),
    __metadata("design:returntype", Promise)
], OpdOperationController.prototype, "removeNurseNoteComment", null);
exports.OpdOperationController = OpdOperationController = __decorate([
    (0, common_1.Controller)('opd-operation'),
    __metadata("design:paramtypes", [opd_operation_service_1.OpdOperationService])
], OpdOperationController);
//# sourceMappingURL=opd-operation.controller.js.map