"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.OpdMedicationService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
let OpdMedicationService = class OpdMedicationService {
    constructor(connection, dynamicConnection) {
        this.connection = connection;
        this.dynamicConnection = dynamicConnection;
    }
    async create(createMedicationOpd) {
        try {
            const [staffId] = await this.connection.query('SELECT email FROM staff WHERE id = ?', [createMedicationOpd.generated_by]);
            if (!staffId || staffId.length === 0) {
                throw new Error(`Medication with id: ${createMedicationOpd.generated_by} not found.`);
            }
            const docemail = staffId.email;
            const opdMedication = await this.connection.query(`INSERT into medication_report(
  medicine_dosage_id,
  pharmacy_id,
  opd_details_id,
  date,
  time,
  remark,
  generated_by
  ) VALUES (?,?,?,?,?,?,?)`, [
                createMedicationOpd.medicine_dosage_id,
                createMedicationOpd.pharmacy_id,
                createMedicationOpd.opd_details_id,
                createMedicationOpd.date,
                createMedicationOpd.time,
                createMedicationOpd.remark,
                createMedicationOpd.generated_by
            ]);
            const opdMedicationIddd = opdMedication.insertId;
            const dynamicUpdateStaff = await this.dynamicConnection.query('SELECT id FROM staff WHERE email = ?', [docemail]);
            const dynamicUPTDStaffId = dynamicUpdateStaff[0].id;
            const dynnnPharmacyid = await this.dynamicConnection.query('SELECT id FROM pharmacy WHERE hos_pharmacy_id = ?', [createMedicationOpd.pharmacy_id]);
            const dynnnPharmaid = dynnnPharmacyid[0].id;
            const dynnnDosageid = await this.dynamicConnection.query('SELECT id FROM medicine_dosage WHERE hospital_medicine_dosage_id = ?', [createMedicationOpd.medicine_dosage_id]);
            const dynnndosageid = dynnnDosageid[0].id;
            const dynnnopdid = await this.dynamicConnection.query('SELECT id FROM opd_details WHERE hos_opd_id = ?', [createMedicationOpd.opd_details_id]);
            const dynnnopdidddd = dynnnopdid[0].id;
            await this.dynamicConnection.query(`INSERT into medication_report(
        medicine_dosage_id,
        pharmacy_id,
        opd_details_id,
        date,
        time,
        remark,
        generated_by,
        Hospital_id,
        hos_medication_report_id
        ) VALUES (?,?,?,?,?,?,?,?,?)`, [
                dynnndosageid,
                dynnnPharmaid,
                dynnnopdidddd,
                createMedicationOpd.date,
                createMedicationOpd.time,
                createMedicationOpd.remark,
                dynamicUPTDStaffId,
                createMedicationOpd.Hospital_id,
                opdMedicationIddd
            ]);
            return [{
                    "data ": {
                        status: process.env.SUCCESS_STATUS_V2,
                        "messege": process.env.MEDICATION,
                        "Added_opd_Medication_Values": await this.connection.query('SELECT * FROM medication_report WHERE id = ?', [opdMedicationIddd])
                    }
                }];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findall() {
        try {
            const getmedication = await this.connection.query(`select medication_report.id, medication_report.date,dayname(medication_report.date) as day,pharmacy.medicine_name,medication_report.time,
    concat(medicine_dosage.dosage," " ,charge_units.unit) as Dosage,
    medication_report.remark from medication_report
    left join pharmacy on medication_report.pharmacy_id = pharmacy.id
    left join medicine_dosage on medication_report.medicine_dosage_id = medicine_dosage.id
    left join charge_units on medicine_dosage.charge_units_id = charge_units.id`);
            return getmedication;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async findMedication(id) {
        try {
            const getmedicationByID = await this.connection.query(`select medication_report.id, medication_report.date,dayname(medication_report.date) as day,pharmacy.medicine_name,medication_report.time,
    concat(medicine_dosage.dosage," " ,charge_units.unit) as Dosage,
    medication_report.remark from medication_report
    left join pharmacy on medication_report.pharmacy_id = pharmacy.id
    left join medicine_dosage on medication_report.medicine_dosage_id = medicine_dosage.id
    left join charge_units on medicine_dosage.charge_units_id = charge_units.id
    where opd_details_id = ?`, [id]);
            return getmedicationByID;
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async update(id, createMedicationOpd) {
        try {
            await this.connection.query(`UPDATE medication_report SET
          medicine_dosage_id=?,
          pharmacy_id=?,
          date=?,
          time=?,
          remark=?
          WHERE id = ?
          `, [
                createMedicationOpd.medicine_dosage_id,
                createMedicationOpd.pharmacy_id,
                createMedicationOpd.date,
                createMedicationOpd.time,
                createMedicationOpd.remark,
                id
            ]);
            const DynopdMedicationip = await this.dynamicConnection.query(`SELECT id from medication_report WHERE hos_medication_report_id = ? and Hospital_id = ?`, [id, createMedicationOpd.Hospital_id]);
            const DynopdMedicationippp = DynopdMedicationip[0].id;
            const dynnnPharmacyid = await this.dynamicConnection.query('SELECT id FROM pharmacy WHERE hos_pharmacy_id = ?', [createMedicationOpd.pharmacy_id]);
            const dynnnPharmaid = dynnnPharmacyid[0].id;
            const dynnnDosageid = await this.dynamicConnection.query('SELECT id FROM medicine_dosage WHERE hospital_medicine_dosage_id = ?', [createMedicationOpd.medicine_dosage_id]);
            const dynnndosageid = dynnnDosageid[0].id;
            await this.dynamicConnection.query(`UPDATE medication_report SET
          medicine_dosage_id=?,
          pharmacy_id=?,
          date=?,
          time=?,
          remark=?,
          Hospital_id=?
          WHERE id = ?
          `, [
                dynnndosageid,
                dynnnPharmaid,
                createMedicationOpd.date,
                createMedicationOpd.time,
                createMedicationOpd.remark,
                createMedicationOpd.Hospital_id,
                DynopdMedicationippp
            ]);
            return [{
                    "data ": {
                        status: process.env.SUCCESS_STATUS_V2,
                        messege: process.env.MEDICATION_UPDATED,
                        "Updated_Opd_medication_Values": await this.connection.query('SELECT * FROM medication_report WHERE id = ?', [id])
                    }
                }];
        }
        catch (error) {
            throw new common_1.HttpException({
                statusCode: common_1.HttpStatus.INTERNAL_SERVER_ERROR,
                message: process.env.ERROR_MESSAGE,
            }, common_1.HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
    async removeMedication(id, Hospital_id) {
        const [existingRecord] = await this.connection.query('SELECT id FROM medication_report WHERE id = ?', [id]);
        if (!existingRecord) {
            return [{ status: "error", message: `ID ${id} does not exist or it has been already deleted` }];
        }
        await this.connection.query('DELETE FROM medication_report WHERE id = ?', [id]);
        const dynamicgetMedication = await this.dynamicConnection.query('SELECT id FROM medication_report WHERE hos_medication_report_id = ?', [id]);
        const dynamicgetMedicationiddd = dynamicgetMedication[0].id;
        await this.dynamicConnection.query('DELETE FROM medication_report WHERE id = ? AND Hospital_id = ?', [dynamicgetMedicationiddd, Hospital_id]);
        return [
            {
                status: process.env.SUCCESS_STATUS_V2,
                message: `${process.env.MEDICATION_ID} ${id} ${process.env.VISITOR_ASSOCIAT}`,
            },
        ];
    }
};
exports.OpdMedicationService = OpdMedicationService;
exports.OpdMedicationService = OpdMedicationService = __decorate([
    (0, common_1.Injectable)(),
    __param(1, (0, typeorm_1.InjectDataSource)('AdminConnection')),
    __metadata("design:paramtypes", [typeorm_2.DataSource,
        typeorm_2.DataSource])
], OpdMedicationService);
//# sourceMappingURL=opd-medication.service.js.map