"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MedicationOpdController = void 0;
const common_1 = require("@nestjs/common");
const opd_medication_service_1 = require("./opd-medication.service");
const opd_medication_entity_1 = require("./entities/opd-medication.entity");
const auth_guard_1 = require("../auth/auth.guard");
let MedicationOpdController = class MedicationOpdController {
    constructor(medicationOpdService) {
        this.medicationOpdService = medicationOpdService;
    }
    create(createMedicationOpd) {
        return this.medicationOpdService.create(createMedicationOpd);
    }
    findall() {
        return this.medicationOpdService.findall();
    }
    findMedication(id) {
        return this.medicationOpdService.findMedication(id);
    }
    update(id, createMedicationOpd) {
        return this.medicationOpdService.update(id, createMedicationOpd);
    }
    async removeMedication(id, Hospital_id) {
        const deleteMedication = await this.medicationOpdService.removeMedication(id, Hospital_id);
        return {
            status: 'success',
            message: `id: ${id} deleted successfully`,
        };
    }
};
exports.MedicationOpdController = MedicationOpdController;
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Post)(),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [opd_medication_entity_1.OpdMedication]),
    __metadata("design:returntype", void 0)
], MedicationOpdController.prototype, "create", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], MedicationOpdController.prototype, "findall", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Get)('/:id'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number]),
    __metadata("design:returntype", void 0)
], MedicationOpdController.prototype, "findMedication", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Patch)('/:id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, opd_medication_entity_1.OpdMedication]),
    __metadata("design:returntype", void 0)
], MedicationOpdController.prototype, "update", null);
__decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Delete)('/:id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Query)('Hospital_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Number]),
    __metadata("design:returntype", Promise)
], MedicationOpdController.prototype, "removeMedication", null);
exports.MedicationOpdController = MedicationOpdController = __decorate([
    (0, common_1.Controller)('opd-medication'),
    __metadata("design:paramtypes", [opd_medication_service_1.OpdMedicationService])
], MedicationOpdController);
//# sourceMappingURL=opd-medication.controller.js.map