"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.OpHubVitalsVibrasenseService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
const event_emitter_1 = require("@nestjs/event-emitter");
let OpHubVitalsVibrasenseService = class OpHubVitalsVibrasenseService {
    constructor(dynamicConnection, connection, eventEmitter) {
        this.dynamicConnection = dynamicConnection;
        this.connection = connection;
        this.eventEmitter = eventEmitter;
    }
    async create(createVitalsVibrasenseDto) {
        if (!createVitalsVibrasenseDto.hospital_id) {
            return {
                status: 'failed',
                message: 'Enter hospital_id to insert vitals',
            };
        }
        try {
            await this.dynamicConnection.query(`insert into VT_Device_Readings (opd_id,
        patient_id,
        device_reading,
        device_name,
        device_id) values (?,?,?,?,?)`, [
                createVitalsVibrasenseDto.opd_id,
                createVitalsVibrasenseDto.patient_id,
                JSON.stringify(createVitalsVibrasenseDto.device_reading),
                createVitalsVibrasenseDto.device_name.toLocaleUpperCase(),
                createVitalsVibrasenseDto.device_id,
            ]);
            let getAdminOPD_id;
            if (createVitalsVibrasenseDto.opd_id) {
                [getAdminOPD_id] = await this.connection.query(`select id from opd_details where Hospital_id = ? and hos_opd_id = ?`, [
                    createVitalsVibrasenseDto.hospital_id,
                    createVitalsVibrasenseDto.opd_id,
                ]);
            }
            else {
                getAdminOPD_id.id = null;
            }
            const [getHosPAtAAYUSH] = await this.dynamicConnection.query(`select aayush_unique_id from patients where id = ?`, [createVitalsVibrasenseDto.patient_id]);
            const [getAdminPat_id] = await this.connection.query(`select id from patients where aayush_unique_id = ? `, [getHosPAtAAYUSH.aayush_unique_id]);
            await this.connection.query(`insert into VT_Device_Readings (opd_id,
          patient_id,
          device_reading,
          device_name,
          device_id) values (?,?,?,?,?)`, [
                getAdminOPD_id.id,
                getAdminPat_id.id,
                JSON.stringify(createVitalsVibrasenseDto.device_reading),
                createVitalsVibrasenseDto.device_name,
                createVitalsVibrasenseDto.device_id,
            ]);
            return {
                status: 'success',
                message: 'vitals details inserted successfully',
                details: createVitalsVibrasenseDto,
            };
        }
        catch (error) {
            console.log(error, 'error');
            return {
                status: 'failed',
                message: 'unable to post vitals data',
                error: error,
            };
        }
    }
    async findAll(opd_id, hospital_id) {
        if (!opd_id && !hospital_id) {
            return {
                status: 'failed',
                message: 'enter hospital_id and opd_id to get vital details',
            };
        }
        try {
            const getVitalDetails = await this.dynamicConnection.query(`select * from VT_Device_Readings where opd_id = ?`, [opd_id]);
            return {
                status: 'success',
                message: 'vitals details fetched successfully',
                details: getVitalDetails,
            };
        }
        catch (error) {
            return {
                status: 'failed',
                message: 'unable to get vital details',
                error: error,
            };
        }
    }
    findOne(id) {
        return `This action returns a #${id} vitalsVibrasense`;
    }
    update(id, updateVitalsVibrasenseDto) {
        return `This action updates a #${id} vitalsVibrasense`;
    }
    remove(id) {
        return `This action removes a #${id} vitalsVibrasense`;
    }
};
exports.OpHubVitalsVibrasenseService = OpHubVitalsVibrasenseService;
exports.OpHubVitalsVibrasenseService = OpHubVitalsVibrasenseService = __decorate([
    (0, common_1.Injectable)(),
    __param(1, (0, typeorm_1.InjectDataSource)('AdminConnection')),
    __metadata("design:paramtypes", [typeorm_2.DataSource,
        typeorm_2.DataSource,
        event_emitter_1.EventEmitter2])
], OpHubVitalsVibrasenseService);
//# sourceMappingURL=op-hub-vitals-vibrasense.service.js.map