"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.OpHubUploadDocPreviewController = void 0;
const common_1 = require("@nestjs/common");
const op_hub_upload_doc_preview_service_1 = require("./op-hub-upload-doc-preview.service");
const client_s3_1 = require("@aws-sdk/client-s3");
const aws_config_1 = require("../aws.config");
const s3_request_presigner_1 = require("@aws-sdk/s3-request-presigner");
let OpHubUploadDocPreviewController = class OpHubUploadDocPreviewController {
    constructor(uploadDocPreviwService) {
        this.uploadDocPreviwService = uploadDocPreviwService;
    }
    async create(dongri, opd_id, hospital_id, abhaAddress) {
        try {
            console.log(dongri, opd_id, hospital_id, abhaAddress, 'req');
            if (dongri) {
                return await this.uploadDocPreviwService.create(dongri, opd_id, hospital_id, abhaAddress);
            }
        }
        catch (error) {
            console.error(error);
            let response = {
                status: 'failed',
                message: 'file upload failed',
            };
            return response;
        }
    }
    async findAll(value) {
        try {
            const s3 = new client_s3_1.S3({
                credentials: {
                    accessKeyId: aws_config_1.awsConfig.accessKeyId,
                    secretAccessKey: aws_config_1.awsConfig.secretAccessKey,
                },
                region: aws_config_1.awsConfig.region,
            });
            const command = new client_s3_1.GetObjectCommand({
                Bucket: aws_config_1.awsConfig.bucketName,
                Key: value,
            });
            const s3Data = await s3.send(command);
            const buffer = Buffer.from(await s3Data.Body.transformToByteArray());
            return buffer.toString('base64');
        }
        catch (error) {
            console.error(error);
            return error;
        }
    }
    async getUrl(value) {
        try {
            const s3Client = new client_s3_1.S3Client({
                credentials: {
                    accessKeyId: aws_config_1.awsConfig.accessKeyId,
                    secretAccessKey: aws_config_1.awsConfig.secretAccessKey,
                },
                region: aws_config_1.awsConfig.region,
            });
            const command = new client_s3_1.GetObjectCommand({
                Bucket: aws_config_1.awsConfig.bucketName,
                Key: value,
            });
            const signedUrl = await (0, s3_request_presigner_1.getSignedUrl)(s3Client, command, {
                expiresIn: 3600,
            });
            return {
                status: 'success',
                message: 'Image url can be accessed for 1 hour',
                imageURL: signedUrl,
            };
        }
        catch (error) {
            console.error(error);
            return error;
        }
    }
    async UploadCaseSheet(dongri, opd_id, hospital_id) {
        try {
            if (dongri) {
                return await this.uploadDocPreviwService.uploadDoc(dongri, opd_id, hospital_id);
            }
        }
        catch (error) {
            let response = {
                status: 'failed',
                message: 'file upload failed',
            };
            return response;
        }
    }
};
exports.OpHubUploadDocPreviewController = OpHubUploadDocPreviewController;
__decorate([
    (0, common_1.Post)(),
    __param(0, (0, common_1.Body)('dongri')),
    __param(1, (0, common_1.Body)('opd_id')),
    __param(2, (0, common_1.Body)('hospital_id')),
    __param(3, (0, common_1.Body)('abhaAddress')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Object, Object, Object]),
    __metadata("design:returntype", Promise)
], OpHubUploadDocPreviewController.prototype, "create", null);
__decorate([
    (0, common_1.Post)('/get'),
    __param(0, (0, common_1.Body)('value')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], OpHubUploadDocPreviewController.prototype, "findAll", null);
__decorate([
    (0, common_1.Post)('/get-signed-url'),
    __param(0, (0, common_1.Body)('value')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], OpHubUploadDocPreviewController.prototype, "getUrl", null);
__decorate([
    (0, common_1.Post)('/uploadCaseSheet'),
    __param(0, (0, common_1.Body)('file')),
    __param(1, (0, common_1.Body)('opd_id')),
    __param(2, (0, common_1.Body)('hospital_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Object, Object]),
    __metadata("design:returntype", Promise)
], OpHubUploadDocPreviewController.prototype, "UploadCaseSheet", null);
exports.OpHubUploadDocPreviewController = OpHubUploadDocPreviewController = __decorate([
    (0, common_1.Controller)('op-hub-upload-doc-preview'),
    __metadata("design:paramtypes", [op_hub_upload_doc_preview_service_1.OpHubUploadDocPreviewService])
], OpHubUploadDocPreviewController);
//# sourceMappingURL=op-hub-upload-doc-preview.controller.js.map