"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.OpHubUnlinkAbhaFromPatientService = void 0;
const common_1 = require("@nestjs/common");
const event_emitter_1 = require("@nestjs/event-emitter");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
let OpHubUnlinkAbhaFromPatientService = class OpHubUnlinkAbhaFromPatientService {
    constructor(dynamicConnection, connection, eventEmitter) {
        this.dynamicConnection = dynamicConnection;
        this.connection = connection;
        this.eventEmitter = eventEmitter;
    }
    async create(createUnlinkAbhaFromPatientDto) {
        if (!createUnlinkAbhaFromPatientDto.hospital_id) {
            return {
                "status": "failed",
                "message": "hospital_id is required"
            };
        }
        if (!createUnlinkAbhaFromPatientDto.patient_id) {
            return {
                "status": "failed",
                "message": "patient_id is required"
            };
        }
        if (!createUnlinkAbhaFromPatientDto.abhaAddress) {
            return {
                "status": "failed",
                "message": "abhaAddress is required"
            };
        }
        try {
            await this.dynamicConnection.query(`delete from patient_abha_address where patient_id = ? and abhaAddress = ?`, [createUnlinkAbhaFromPatientDto.patient_id,
                createUnlinkAbhaFromPatientDto.abhaAddress]);
            return {
                "status": "success",
                "message": "abha address unlinked from patient successfully"
            };
        }
        catch (error) {
            return {
                "status": "failed",
                "message": "failed to unlink abha address from patient",
                error: error
            };
        }
    }
};
exports.OpHubUnlinkAbhaFromPatientService = OpHubUnlinkAbhaFromPatientService;
exports.OpHubUnlinkAbhaFromPatientService = OpHubUnlinkAbhaFromPatientService = __decorate([
    (0, common_1.Injectable)(),
    __param(1, (0, typeorm_1.InjectDataSource)('AdminConnection')),
    __metadata("design:paramtypes", [typeorm_2.DataSource,
        typeorm_2.DataSource,
        event_emitter_1.EventEmitter2])
], OpHubUnlinkAbhaFromPatientService);
//# sourceMappingURL=op-hub-unlink-abha-from-patient.service.js.map