"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.OpHubTokenInitiateService = void 0;
const common_1 = require("@nestjs/common");
const event_emitter_1 = require("@nestjs/event-emitter");
const typeorm_1 = require("@nestjs/typeorm");
const axios_1 = require("axios");
const op_hub_token_generation_service_1 = require("../op-hub-token-generation/op-hub-token-generation.service");
const typeorm_2 = require("typeorm");
let OpHubTokenInitiateService = class OpHubTokenInitiateService {
    constructor(dynamicConnection, connection, eventEmitter, tokenGeneration) {
        this.dynamicConnection = dynamicConnection;
        this.connection = connection;
        this.eventEmitter = eventEmitter;
        this.tokenGeneration = tokenGeneration;
    }
    async findAll() {
        const currentDate = new Date();
        const year = currentDate.getFullYear();
        const month = String(currentDate.getMonth() + 1).padStart(2, '0');
        const day = String(currentDate.getDate()).padStart(2, '0');
        const TodayDate = `${year}-${month}-${day}`;
        const getTokenInitiatingDetails = await this.connection.query(`
      SELECT distinct doctor, shift_id, Hospital_id  
      FROM appointment 
      WHERE date = curdate() and appointment.doctor;
    `);
        for await (const { doctor, shift_id, Hospital_id, } of getTokenInitiatingDetails) {
            let body = {
                staff_id: doctor,
                shift_id: shift_id,
                Hospital_id: Hospital_id,
                date: TodayDate,
            };
            this.tokenGeneration.create(body);
        }
        const getsendNotificationDetails = await this.connection.query(`
      SELECT patients.patient_name,
             concat (patients.dial_code,"",patients.mobileno) mobileno,
             patients.email,
             CONCAT("Dr. ",staff.name, " ", staff.surname) doctorName,
             hospitals.hospital_name,
             appointment_queue.position token,
             DATE_FORMAT(appointment.date, '%D %b %Y') date,
             DATE_FORMAT(appointment.time, '%h:%i %p') time
      FROM appointment 
      LEFT JOIN patients ON appointment.patient_id = patients.id
      LEFT JOIN hospitals ON hospitals.plenome_id = appointment.Hospital_id
      LEFT JOIN appointment_queue ON appointment_queue.appointment_id = appointment.id
      LEFT JOIN staff ON staff.id = appointment.doctor
      WHERE appointment.date = curdate() and staff.id;
    `);
        for (const { mobileno, date, doctorName, token, } of getsendNotificationDetails) {
            let body = {
                mobileNumber: mobileno,
                date: date,
                doctor: doctorName,
                TK_NO: token,
            };
            await axios_1.default.post('https://notifications.plenome.com//sending-sms-token-no', body);
        }
        for (const { email, patient_name, hospital_name, date, time, token, } of getsendNotificationDetails) {
            let body = {
                email: email,
                name: patient_name,
                HosName: hospital_name,
                date_time: date + ' ' + time,
                TOKEN_NO: token,
                company: 'PLENOME',
            };
            await axios_1.default.post('https://notifications.plenome.com//email-token-number-send', body);
        }
        return `This action returns all tokenInitiate`;
    }
};
exports.OpHubTokenInitiateService = OpHubTokenInitiateService;
exports.OpHubTokenInitiateService = OpHubTokenInitiateService = __decorate([
    (0, common_1.Injectable)(),
    __param(1, (0, typeorm_1.InjectDataSource)('AdminConnection')),
    __param(3, (0, common_1.Inject)((0, common_1.forwardRef)(() => op_hub_token_generation_service_1.OpHubTokenGenerationService))),
    __metadata("design:paramtypes", [typeorm_2.DataSource,
        typeorm_2.DataSource,
        event_emitter_1.EventEmitter2,
        op_hub_token_generation_service_1.OpHubTokenGenerationService])
], OpHubTokenInitiateService);
//# sourceMappingURL=op-hub-token-initiate.service.js.map