"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.OpHubSendNotificationService = void 0;
const common_1 = require("@nestjs/common");
const event_emitter_1 = require("@nestjs/event-emitter");
const typeorm_1 = require("@nestjs/typeorm");
const axios_1 = require("axios");
const typeorm_2 = require("typeorm");
let OpHubSendNotificationService = class OpHubSendNotificationService {
    constructor(dynamicConnection, connection, eventEmitter) {
        this.dynamicConnection = dynamicConnection;
        this.connection = connection;
        this.eventEmitter = eventEmitter;
    }
    async SendNotificationForPatientProfile(from_staff_id, to_staff_id, room_id, hospital_id) {
        if (!hospital_id) {
            return {
                "status": "failed",
                "messege": "enter hospital_id to post clinical notes"
            };
        }
        const [getBearerToken] = await this.connection.query(`select token from op_hub_firebase_auth_bearer_token`);
        const token = 'Bearer ' + getBearerToken.token;
        if (from_staff_id && to_staff_id) {
            const [getFromStaffEmail] = await this.dynamicConnection.query(`select * from staff where id = ?`, [from_staff_id]);
            const [getToStaffEmail] = await this.dynamicConnection.query(`select email from staff where id = ?`, [from_staff_id]);
            if (getToStaffEmail) {
                const [getFcmToken] = await this.connection.query(`select fcm_token from hospital_staffs where username = ?`, [getToStaffEmail.email]);
                if (getFcmToken) {
                    const notificationBody = {
                        message: {
                            token: getFcmToken.fcm_token,
                            notification: {
                                body: room_id,
                                title: "Dr." + getFromStaffEmail.name + " " + getFromStaffEmail.surname + " is calling you",
                            },
                        },
                    };
                    const headers = {
                        accept: '*/*',
                        'Accept-Language': 'en-US',
                        'Content-Type': 'application/json',
                        Authorization: token,
                    };
                    const authUrl = `https://fcm.googleapis.com/v1/projects/plenome-hub/messages:send`;
                    try {
                        await axios_1.default.post(authUrl, notificationBody, { headers });
                    }
                    catch (error) {
                        console.log(error.response.data, "ppp");
                    }
                    return {
                        status: "success",
                        message: "Notification sent successfully",
                    };
                }
            }
        }
    }
};
exports.OpHubSendNotificationService = OpHubSendNotificationService;
exports.OpHubSendNotificationService = OpHubSendNotificationService = __decorate([
    (0, common_1.Injectable)(),
    __param(1, (0, typeorm_1.InjectDataSource)('AdminConnection')),
    __metadata("design:paramtypes", [typeorm_2.DataSource,
        typeorm_2.DataSource,
        event_emitter_1.EventEmitter2])
], OpHubSendNotificationService);
//# sourceMappingURL=op-hub-send-notification.service.js.map