"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PreviewDoc = exports.PatientDetailsDto = void 0;
const swagger_1 = require("@nestjs/swagger");
const op_hub_clinical_notes_with_abha_entity_1 = require("../../op-hub-clinical-notes-with-abha/entities/op-hub-clinical-notes-with-abha.entity");
const update_manual_vital_dto_1 = require("../../op-hub-manual-vitals/dto/update-manual_vital.dto");
const op_hub_opd_prescription_entity_1 = require("../../op-hub-opd-prescription/entities/op-hub-opd-prescription.entity");
class PatientDetailsDto {
}
exports.PatientDetailsDto = PatientDetailsDto;
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Name of the patient',
        example: 'Test',
    }),
    __metadata("design:type", String)
], PatientDetailsDto.prototype, "patientName", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Date of birth of the patient in YYYY-MM-DD format',
        example: '2016-10-18',
    }),
    __metadata("design:type", String)
], PatientDetailsDto.prototype, "dob", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Age of the patient',
        example: '8',
    }),
    __metadata("design:type", String)
], PatientDetailsDto.prototype, "age", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Mobile number of the patient',
        example: '7092327667',
    }),
    __metadata("design:type", String)
], PatientDetailsDto.prototype, "mobileno", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Email address of the patient',
        example: '',
        required: false,
    }),
    __metadata("design:type", String)
], PatientDetailsDto.prototype, "email", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Gender of the patient',
        example: 'Male',
    }),
    __metadata("design:type", String)
], PatientDetailsDto.prototype, "gender", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Address of the patient',
        example: 'Chennai',
    }),
    __metadata("design:type", String)
], PatientDetailsDto.prototype, "address", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Blood group of the patient',
        example: '-',
        required: false,
    }),
    __metadata("design:type", String)
], PatientDetailsDto.prototype, "patient_blood_group", void 0);
class DoctorDetailsDto {
}
__decorate([
    (0, swagger_1.ApiProperty)({ example: 'Matheshwari N' }),
    __metadata("design:type", String)
], DoctorDetailsDto.prototype, "doctorName", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: '1122112' }),
    __metadata("design:type", String)
], DoctorDetailsDto.prototype, "employee_id", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 'Male' }),
    __metadata("design:type", String)
], DoctorDetailsDto.prototype, "gender", void 0);
class PreviewDoc {
}
exports.PreviewDoc = PreviewDoc;
__decorate([
    (0, swagger_1.ApiProperty)({ type: DoctorDetailsDto }),
    __metadata("design:type", DoctorDetailsDto)
], PreviewDoc.prototype, "doctor_details", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: op_hub_clinical_notes_with_abha_entity_1.ClinicalNotesResponseDto }),
    __metadata("design:type", op_hub_clinical_notes_with_abha_entity_1.ClinicalNotesResponseDto)
], PreviewDoc.prototype, "clinical_notes", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: [op_hub_opd_prescription_entity_1.PrescriptionDetailDto] }),
    __metadata("design:type", Array)
], PreviewDoc.prototype, "prescription", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: update_manual_vital_dto_1.UpdateManualVitalDto }),
    __metadata("design:type", update_manual_vital_dto_1.UpdateManualVitalDto)
], PreviewDoc.prototype, "vitals", void 0);
//# sourceMappingURL=op-hub-preview-doc.entity.js.map