"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.OpHubPrescriptionService = void 0;
const common_1 = require("@nestjs/common");
const event_emitter_1 = require("@nestjs/event-emitter");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
let OpHubPrescriptionService = class OpHubPrescriptionService {
    constructor(dynamicConnection, connection, eventEmitter) {
        this.dynamicConnection = dynamicConnection;
        this.connection = connection;
        this.eventEmitter = eventEmitter;
    }
    async create(createPrescriptionDto) {
        if (createPrescriptionDto.Hospital_id) {
            try {
                let numb;
                try {
                    numb = createPrescriptionDto.appointment_id.replace(/[a-zA-Z]/g, '');
                }
                catch (error) {
                    numb = createPrescriptionDto.appointment_id;
                }
                const [patientMobHos] = await this.dynamicConnection.query(`select mobileno from patients where id = ?`, [createPrescriptionDto.patient_id]);
                let HosPatientMobileNo = patientMobHos.mobileno;
                let HosTrimmedMobileno;
                if (HosPatientMobileNo.length > 10) {
                    HosTrimmedMobileno = HosPatientMobileNo.startsWith('91') ? HosPatientMobileNo.slice(2) : HosPatientMobileNo;
                }
                else {
                    HosTrimmedMobileno = HosPatientMobileNo;
                }
                const [AdminPatId] = await this.connection.query(`select id from patients where mobileno = ?`, [HosTrimmedMobileno]);
                const [appntHOS] = await this.dynamicConnection.query(`select * from appointment where id = ?`, [numb]);
                const [AdminApptId] = await this.connection.query(`select id from appointment 
where Hospital_id = ? and hos_appointment_id = ?`, [createPrescriptionDto.Hospital_id,
                    appntHOS.id
                ]);
                await this.connection.query(`insert into patient_records(patient_id,record_name,files,
      record_type_id,appointment_id) values(?,?,?,?,?)`, [
                    AdminPatId.id,
                    createPrescriptionDto.record_name,
                    createPrescriptionDto.files,
                    3,
                    AdminApptId.id
                ]);
                return {
                    "status": "success",
                    "message": "Prescription added successfully"
                };
            }
            catch (error) {
                console.log(error);
                return error;
            }
        }
        else {
            return {
                "status": "failed",
                "message": "Enter hospital_id to upload prescription"
            };
        }
    }
    async findAll(createPrescriptionDto) {
        if (createPrescriptionDto.Hospital_id) {
            if (createPrescriptionDto.patient_id) {
                try {
                    const [patientMobHos] = await this.dynamicConnection.query(`select mobileno from patients where id = ?`, [createPrescriptionDto.patient_id]);
                    const [AdminPatId] = await this.connection.query(`select id from patients where mobileno = ?`, [patientMobHos.mobileno]);
                    const getPrescr = await this.connection.query(`select patient_records.record_name,patient_records.files,patient_records.tags,
      opd_details.hos_opd_id,concat("Dr. ",staff.name," ",staff.surname) doctorName,CONCAT(DATE_FORMAT(appointment.date, '%D %b %Y'), ",", DATE_FORMAT(appointment.time, '%h:%i %p')) appointDate
             from patient_records
             left join appointment on appointment.id = patient_records.appointment_id
             left join visit_details on visit_details.id = appointment.visit_details_id
             left join opd_details on opd_details.id = visit_details.opd_details_id
             left join staff on staff.id = appointment.doctor
             where patient_records.patient_id = ? and record_type_id = 3`, [AdminPatId.id]);
                    return getPrescr;
                }
                catch (error) {
                    return error;
                }
            }
            else {
                return {
                    "status": "failed",
                    "message": "Enter hospital_id to get prescription"
                };
            }
        }
        else {
            return {
                "status": "failed",
                "message": "Enter hospital_id to get prescription"
            };
        }
    }
};
exports.OpHubPrescriptionService = OpHubPrescriptionService;
exports.OpHubPrescriptionService = OpHubPrescriptionService = __decorate([
    (0, common_1.Injectable)(),
    __param(1, (0, typeorm_1.InjectDataSource)('AdminConnection')),
    __metadata("design:paramtypes", [typeorm_2.DataSource,
        typeorm_2.DataSource,
        event_emitter_1.EventEmitter2])
], OpHubPrescriptionService);
//# sourceMappingURL=op-hub-prescription.service.js.map