import { EventEmitter2 } from '@nestjs/event-emitter';
import { DataSource } from 'typeorm';
import { Patientprofile, ABHAProfile } from './entities/op-hub-patient-profile.entity';
import { FaceAuthService } from 'src/face-auth/face-auth.service';
export declare class OpHubPatientProfileService {
    private readonly dynamicConnection;
    private readonly connection;
    private readonly eventEmitter;
    private readonly addAppointmentService;
    constructor(dynamicConnection: DataSource, connection: DataSource, eventEmitter: EventEmitter2, addAppointmentService: FaceAuthService);
    getPatientDetails(patientId: number, Hospital_id: number): Promise<any>;
    updatePatientDetails(patientId: number, Entity: Patientprofile, Hospital_id: number): Promise<any[] | {
        status: string;
        message: string;
    }>;
    updateOnlyAbhaNumber(aayush_unique_id: any, abhaNumber: any): Promise<any>;
    updatePatientABHAaddress(patientId: number, Entity: Patientprofile, Hospital_id: number): Promise<any[]>;
    updatePatientABHANumber(patientId: number, Entity: ABHAProfile, Hospital_id: number): Promise<any[] | {
        status: string;
        message: string;
    }>;
    updatePatientVerifyABHANumber(patientId: number, Entity: ABHAProfile, Hospital_id: number): Promise<any[]>;
    getRegistrationStatus(abhaDetails: any, hospital_id: number): Promise<{
        status: string;
        data: any;
        message?: undefined;
    } | {
        status: string;
        message: string;
        data?: undefined;
    }>;
}
