"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.OpHubPatientProfileController = void 0;
const common_1 = require("@nestjs/common");
const op_hub_patient_profile_service_1 = require("./op-hub-patient-profile.service");
const op_hub_patient_profile_entity_1 = require("./entities/op-hub-patient-profile.entity");
let OpHubPatientProfileController = class OpHubPatientProfileController {
    constructor(patientprofileService) {
        this.patientprofileService = patientprofileService;
    }
    async getPatientDetails(patientId, hospital_id) {
        return this.patientprofileService.getPatientDetails(patientId, hospital_id);
    }
    updateStatus(patientId, Entity, hospital_id) {
        return this.patientprofileService.updatePatientDetails(patientId, Entity, hospital_id);
    }
    updateabhaAddress(patientId, Entity, hospital_id) {
        return this.patientprofileService.updatePatientABHAaddress(patientId, Entity, hospital_id);
    }
    updateabhaNumber(patientId, Entity, hospital_id) {
        return this.patientprofileService.updatePatientABHANumber(patientId, Entity, hospital_id);
    }
    updateVerifyabhaNumber(patientId, Entity, hospital_id) {
        return this.patientprofileService.updatePatientVerifyABHANumber(patientId, Entity, hospital_id);
    }
    getRegistrationStatus(Entity, hospital_id) {
        return this.patientprofileService.getRegistrationStatus(Entity, hospital_id);
    }
    updateNumber(aayush_unique_id, abhaNumber) {
        return this.patientprofileService.updateOnlyAbhaNumber(aayush_unique_id, abhaNumber);
    }
};
exports.OpHubPatientProfileController = OpHubPatientProfileController;
__decorate([
    (0, common_1.Get)(),
    __param(0, (0, common_1.Query)('patientId')),
    __param(1, (0, common_1.Query)('hospital_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Number]),
    __metadata("design:returntype", Promise)
], OpHubPatientProfileController.prototype, "getPatientDetails", null);
__decorate([
    (0, common_1.Patch)(),
    __param(0, (0, common_1.Query)('patientId')),
    __param(1, (0, common_1.Body)()),
    __param(2, (0, common_1.Query)('hospital_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, op_hub_patient_profile_entity_1.Patientprofile, Number]),
    __metadata("design:returntype", void 0)
], OpHubPatientProfileController.prototype, "updateStatus", null);
__decorate([
    (0, common_1.Patch)('/abha-address'),
    __param(0, (0, common_1.Query)('patientId')),
    __param(1, (0, common_1.Body)()),
    __param(2, (0, common_1.Query)('hospital_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, op_hub_patient_profile_entity_1.Patientprofile, Number]),
    __metadata("design:returntype", void 0)
], OpHubPatientProfileController.prototype, "updateabhaAddress", null);
__decorate([
    (0, common_1.Patch)('/abha-number'),
    __param(0, (0, common_1.Query)('patientId')),
    __param(1, (0, common_1.Body)()),
    __param(2, (0, common_1.Query)('hospital_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, op_hub_patient_profile_entity_1.ABHAProfile, Number]),
    __metadata("design:returntype", void 0)
], OpHubPatientProfileController.prototype, "updateabhaNumber", null);
__decorate([
    (0, common_1.Patch)('/verify-abha-number'),
    __param(0, (0, common_1.Query)('patientId')),
    __param(1, (0, common_1.Body)()),
    __param(2, (0, common_1.Query)('hospital_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, op_hub_patient_profile_entity_1.ABHAProfile, Number]),
    __metadata("design:returntype", void 0)
], OpHubPatientProfileController.prototype, "updateVerifyabhaNumber", null);
__decorate([
    (0, common_1.Post)('/get-registration-status'),
    __param(0, (0, common_1.Body)()),
    __param(1, (0, common_1.Query)('hospital_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Number]),
    __metadata("design:returntype", void 0)
], OpHubPatientProfileController.prototype, "getRegistrationStatus", null);
__decorate([
    (0, common_1.Patch)('/update-abha-number'),
    __param(0, (0, common_1.Query)('aayush_unique_id')),
    __param(1, (0, common_1.Query)('abhaNumber')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object]),
    __metadata("design:returntype", void 0)
], OpHubPatientProfileController.prototype, "updateNumber", null);
exports.OpHubPatientProfileController = OpHubPatientProfileController = __decorate([
    (0, common_1.Controller)('op-hub-patient-profile'),
    __metadata("design:paramtypes", [op_hub_patient_profile_service_1.OpHubPatientProfileService])
], OpHubPatientProfileController);
//# sourceMappingURL=op-hub-patient-profile.controller.js.map