"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.OpHubPatientFromQrController = void 0;
const common_1 = require("@nestjs/common");
const op_hub_patient_from_qr_service_1 = require("./op-hub-patient-from-qr.service");
const op_hub_patient_from_qr_entity_1 = require("./entities/op-hub-patient-from-qr.entity");
let OpHubPatientFromQrController = class OpHubPatientFromQrController {
    constructor(patientFromQrService) {
        this.patientFromQrService = patientFromQrService;
    }
    create(createPatientFromQr) {
        return this.patientFromQrService.create(createPatientFromQr);
    }
    AddPatient(createPatientFromQr) {
        return this.patientFromQrService.CreateManually(createPatientFromQr);
    }
    patCheck(createPatientFromQr) {
        if (!createPatientFromQr.mobileno || !createPatientFromQr.patient_name || !createPatientFromQr.dob || !createPatientFromQr.gender) {
            return {
                status_code: 400,
                status: 'Failed',
                message: 'Provide all required fields: mobileno, patient_name, dob'
            };
        }
        return this.patientFromQrService.checkWithDetails(createPatientFromQr);
    }
};
exports.OpHubPatientFromQrController = OpHubPatientFromQrController;
__decorate([
    (0, common_1.Post)('scan'),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [op_hub_patient_from_qr_entity_1.PatientFromQr]),
    __metadata("design:returntype", void 0)
], OpHubPatientFromQrController.prototype, "create", null);
__decorate([
    (0, common_1.Post)('AddNewPatient'),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [op_hub_patient_from_qr_entity_1.Patient]),
    __metadata("design:returntype", void 0)
], OpHubPatientFromQrController.prototype, "AddPatient", null);
__decorate([
    (0, common_1.Post)('checkExistingPatient'),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [op_hub_patient_from_qr_entity_1.Patient]),
    __metadata("design:returntype", void 0)
], OpHubPatientFromQrController.prototype, "patCheck", null);
exports.OpHubPatientFromQrController = OpHubPatientFromQrController = __decorate([
    (0, common_1.Controller)('op-hub-patient-from-qr'),
    __metadata("design:paramtypes", [op_hub_patient_from_qr_service_1.OpHubPatientFromQrService])
], OpHubPatientFromQrController);
//# sourceMappingURL=op-hub-patient-from-qr.controller.js.map