"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.OpHubPatientAppointmentListController = exports.AppointmentHistoryDto = void 0;
const common_1 = require("@nestjs/common");
const op_hub_patient_appointment_list_service_1 = require("./op-hub-patient-appointment-list.service");
const swagger_1 = require("@nestjs/swagger");
const op_hub_appointment_status_controller_1 = require("../op-hub-appointment-status/op-hub-appointment-status.controller");
const op_hub_appointment_entity_1 = require("../op-hub-appointment/entities/op-hub-appointment.entity");
class AppointmentHistoryDto {
}
exports.AppointmentHistoryDto = AppointmentHistoryDto;
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Name of the patient' }),
    __metadata("design:type", String)
], AppointmentHistoryDto.prototype, "patient_name", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Unique identifier for the patient' }),
    __metadata("design:type", Number)
], AppointmentHistoryDto.prototype, "patient_id", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Appointment date and time' }),
    __metadata("design:type", String)
], AppointmentHistoryDto.prototype, "appointment_date", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Appointment date in database format' }),
    __metadata("design:type", String)
], AppointmentHistoryDto.prototype, "comp", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Mobile number of the patient' }),
    __metadata("design:type", String)
], AppointmentHistoryDto.prototype, "Mobile", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Doctor’s specialty' }),
    __metadata("design:type", String)
], AppointmentHistoryDto.prototype, "doctorSpecialist", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Dial code for the phone number' }),
    __metadata("design:type", String)
], AppointmentHistoryDto.prototype, "dial_code", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Unique identifier for the doctor' }),
    __metadata("design:type", Number)
], AppointmentHistoryDto.prototype, "doctor", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Name of the consultant doctor' }),
    __metadata("design:type", String)
], AppointmentHistoryDto.prototype, "consultant", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Current status of the appointment' }),
    __metadata("design:type", String)
], AppointmentHistoryDto.prototype, "appointment_status", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Identifier for the appointment status' }),
    __metadata("design:type", String)
], AppointmentHistoryDto.prototype, "appointment_status_id", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Color code representing the appointment status' }),
    __metadata("design:type", String)
], AppointmentHistoryDto.prototype, "color_code", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Unique identifier for the appointment' }),
    __metadata("design:type", String)
], AppointmentHistoryDto.prototype, "appointment_id", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Payment status of the appointment' }),
    __metadata("design:type", String)
], AppointmentHistoryDto.prototype, "payment_status", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Fees for the appointment' }),
    __metadata("design:type", Number)
], AppointmentHistoryDto.prototype, "apptFees", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Unique identifier for the OPD' }),
    __metadata("design:type", String)
], AppointmentHistoryDto.prototype, "opd_id", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Appointment token' }),
    __metadata("design:type", String)
], AppointmentHistoryDto.prototype, "appointment_token", void 0);
let OpHubPatientAppointmentListController = class OpHubPatientAppointmentListController {
    constructor(patientAppointmentListService) {
        this.patientAppointmentListService = patientAppointmentListService;
    }
    findAll(hospital_id, patient_id, date, doctor) {
        return this.patientAppointmentListService.findAll(hospital_id, patient_id, date, doctor);
    }
    findAllUpcoming(hospital_id, patient_id, date, doctor) {
        return this.patientAppointmentListService.findAllUpcomming(hospital_id, patient_id, date, doctor);
    }
    findAllToday(hospital_id, patient_id, date, doctor) {
        return this.patientAppointmentListService.findAllToday(hospital_id, patient_id, date, doctor);
    }
    async findAllTodayV2(hospital_id, patient_id, date, doctor, limit, page) {
        if (!patient_id || !hospital_id) {
            return {
                status_code: process.env.ERROR_STATUS_CODE_PARAMS_MISSING,
                status: process.env.ERROR_STATUS,
                message: process.env.HOS_AND_PAT_ERR
            };
        }
        try {
            let final_out = await this.patientAppointmentListService.findAllTodayV2(hospital_id, patient_id, date, doctor, +limit || 10, +page || 1);
            if (final_out?.details.length > 0) {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE_V2,
                    status: process.env.SUCCESS_STATUS_V2,
                    message: process.env.SUCCESS_MESSAGE_V2,
                    data: final_out.details,
                    total: final_out.count,
                };
            }
            else {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE_V2,
                    status: process.env.SUCCESS_STATUS_V2,
                    message: process.env.DATA_NOT_FOUND_V2,
                    data: []
                };
            }
        }
        catch (error) {
            return {
                status_code: process.env.ERROR_STATUS_CODE_V2,
                "status": process.env.ERROR_STATUS_V2,
                "message": process.env.ERROR_MESSAGE_V2,
            };
        }
    }
    async findAllHistoryV2(hospital_id, patient_id, date, doctor, limit, page) {
        if (!patient_id || !hospital_id) {
            return {
                status_code: process.env.ERROR_STATUS_CODE_PARAMS_MISSING,
                status: process.env.ERROR_STATUS,
                message: process.env.HOS_AND_PAT_ERR
            };
        }
        try {
            let final_out = await this.patientAppointmentListService.findAllHistoryV2(hospital_id, patient_id, date, doctor, +limit || 10, +page || 1);
            if (final_out?.details.length > 0) {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE_V2,
                    status: process.env.SUCCESS_STATUS_V2,
                    message: process.env.SUCCESS_MESSAGE_V2,
                    data: final_out.details,
                    total: final_out.count,
                };
            }
            else {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE_V2,
                    status: process.env.SUCCESS_STATUS_V2,
                    message: process.env.DATA_NOT_FOUND_V2,
                    data: []
                };
            }
        }
        catch (error) {
            console.log(error, "error");
            return {
                status_code: process.env.ERROR_STATUS_CODE_V2,
                "status": process.env.ERROR_STATUS_V2,
                "message": process.env.ERROR_MESSAGE_V2,
            };
        }
    }
    async findAllUpcomingV2(hospital_id, patient_id, date, doctor, limit, page) {
        try {
            let final_out = await this.patientAppointmentListService.findAllUpcommingV2(hospital_id, patient_id, date, doctor, +limit || 10, +page || 1);
            if (final_out?.details.length > 0) {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE_V2,
                    status: process.env.SUCCESS_STATUS_V2,
                    message: process.env.SUCCESS_MESSAGE_V2,
                    data: final_out.details,
                    total: final_out.count,
                };
            }
            else {
                return {
                    status_code: process.env.SUCCESS_STATUS_CODE_V2,
                    status: process.env.SUCCESS_STATUS_V2,
                    message: process.env.DATA_NOT_FOUND_V2,
                    data: []
                };
            }
        }
        catch (error) {
            console.log(error, "error");
            return {
                status_code: process.env.ERROR_STATUS_CODE_V2,
                "status": process.env.ERROR_STATUS_V2,
                "message": process.env.ERROR_MESSAGE_V2,
            };
        }
    }
};
exports.OpHubPatientAppointmentListController = OpHubPatientAppointmentListController;
__decorate([
    (0, common_1.Get)('/history'),
    (0, swagger_1.ApiOperation)({ summary: 'Retrieve appointment history for a patient' }),
    (0, swagger_1.ApiQuery)({ name: 'hospital_id', required: true, description: 'ID of the hospital', type: Number }),
    (0, swagger_1.ApiQuery)({ name: 'patient_id', required: true, description: 'ID of the patient', type: Number }),
    (0, swagger_1.ApiQuery)({ name: 'date', required: false, description: 'Date of the appointment', type: String }),
    (0, swagger_1.ApiQuery)({ name: 'doctor', required: false, description: 'ID of the doctor', type: Number }),
    (0, swagger_1.ApiResponse)({ status: 200, description: 'Successfully retrieved appointment history', type: [AppointmentHistoryDto] }),
    (0, swagger_1.ApiResponse)({
        status: 404,
        description: 'Patient charge not found.',
    }),
    (0, swagger_1.ApiResponse)({
        status: 400,
        description: 'Bad request. Validation errors or missing parameters.',
        type: op_hub_appointment_entity_1.ErrorResponse400
    }),
    (0, swagger_1.ApiResponse)({
        status: 500,
        description: 'Internal server error.',
        type: op_hub_appointment_status_controller_1.ErrorResponse500
    }),
    __param(0, (0, common_1.Query)('hospital_id')),
    __param(1, (0, common_1.Query)('patient_id')),
    __param(2, (0, common_1.Query)('date')),
    __param(3, (0, common_1.Query)('doctor')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Number, Object, Number]),
    __metadata("design:returntype", void 0)
], OpHubPatientAppointmentListController.prototype, "findAll", null);
__decorate([
    (0, common_1.Get)('/upcoming'),
    (0, swagger_1.ApiOperation)({ summary: 'Retrieve upcoming appointments for a patient' }),
    (0, swagger_1.ApiQuery)({ name: 'hospital_id', required: true, description: 'ID of the hospital', type: Number }),
    (0, swagger_1.ApiQuery)({ name: 'patient_id', required: true, description: 'ID of the patient', type: Number }),
    (0, swagger_1.ApiQuery)({ name: 'date', required: false, description: 'Date for filtering upcoming appointments', type: String }),
    (0, swagger_1.ApiQuery)({ name: 'doctor', required: false, description: 'ID of the doctor', type: Number }),
    (0, swagger_1.ApiResponse)({ status: 200, description: 'Successfully retrieved upcoming appointments', type: [AppointmentHistoryDto] }),
    (0, swagger_1.ApiResponse)({
        status: 404,
        description: 'Patient charge not found.',
    }),
    (0, swagger_1.ApiResponse)({
        status: 400,
        description: 'Bad request. Validation errors or missing parameters.',
        type: op_hub_appointment_entity_1.ErrorResponse400
    }),
    (0, swagger_1.ApiResponse)({
        status: 500,
        description: 'Internal server error.',
        type: op_hub_appointment_status_controller_1.ErrorResponse500
    }),
    __param(0, (0, common_1.Query)('hospital_id')),
    __param(1, (0, common_1.Query)('patient_id')),
    __param(2, (0, common_1.Query)('date')),
    __param(3, (0, common_1.Query)('doctor')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Number, Object, Number]),
    __metadata("design:returntype", void 0)
], OpHubPatientAppointmentListController.prototype, "findAllUpcoming", null);
__decorate([
    (0, common_1.Get)('/today'),
    (0, swagger_1.ApiOperation)({ summary: 'Retrieve today\'s appointments for a patient' }),
    (0, swagger_1.ApiQuery)({ name: 'hospital_id', required: true, description: 'ID of the hospital', type: Number }),
    (0, swagger_1.ApiQuery)({ name: 'patient_id', required: true, description: 'ID of the patient', type: Number }),
    (0, swagger_1.ApiQuery)({ name: 'date', required: false, description: 'Date for filtering today\'s appointments', type: String }),
    (0, swagger_1.ApiQuery)({ name: 'doctor', required: false, description: 'ID of the doctor', type: Number }),
    (0, swagger_1.ApiResponse)({ status: 200, description: 'Successfully retrieved today appointments', type: [AppointmentHistoryDto] }),
    (0, swagger_1.ApiResponse)({
        status: 404,
        description: 'Patient charge not found.',
    }),
    (0, swagger_1.ApiResponse)({
        status: 400,
        description: 'Bad request. Validation errors or missing parameters.',
        type: op_hub_appointment_entity_1.ErrorResponse400
    }),
    (0, swagger_1.ApiResponse)({
        status: 500,
        description: 'Internal server error.',
        type: op_hub_appointment_status_controller_1.ErrorResponse500
    }),
    __param(0, (0, common_1.Query)('hospital_id')),
    __param(1, (0, common_1.Query)('patient_id')),
    __param(2, (0, common_1.Query)('date')),
    __param(3, (0, common_1.Query)('doctor')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Number, Object, Number]),
    __metadata("design:returntype", void 0)
], OpHubPatientAppointmentListController.prototype, "findAllToday", null);
__decorate([
    (0, common_1.Get)('/v2/today'),
    (0, swagger_1.ApiOperation)({ summary: 'Retrieve today\'s appointments for a patient' }),
    (0, swagger_1.ApiQuery)({ name: 'hospital_id', required: true, description: 'ID of the hospital', type: Number }),
    (0, swagger_1.ApiQuery)({ name: 'patient_id', required: true, description: 'ID of the patient', type: Number }),
    (0, swagger_1.ApiQuery)({ name: 'date', required: false, description: 'Date for filtering today\'s appointments', type: String }),
    (0, swagger_1.ApiQuery)({ name: 'doctor', required: false, description: 'ID of the doctor', type: Number }),
    (0, swagger_1.ApiResponse)({ status: 200, description: 'Successfully retrieved today appointments', type: [AppointmentHistoryDto] }),
    (0, swagger_1.ApiResponse)({
        status: 404,
        description: 'Patient charge not found.',
    }),
    (0, swagger_1.ApiResponse)({
        status: 400,
        description: 'Bad request. Validation errors or missing parameters.',
        type: op_hub_appointment_entity_1.ErrorResponse400
    }),
    (0, swagger_1.ApiResponse)({
        status: 500,
        description: 'Internal server error.',
        type: op_hub_appointment_status_controller_1.ErrorResponse500
    }),
    __param(0, (0, common_1.Query)('hospital_id')),
    __param(1, (0, common_1.Query)('patient_id')),
    __param(2, (0, common_1.Query)('date')),
    __param(3, (0, common_1.Query)('doctor')),
    __param(4, (0, common_1.Query)('limit')),
    __param(5, (0, common_1.Query)('page')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Number, Object, Number, String, String]),
    __metadata("design:returntype", Promise)
], OpHubPatientAppointmentListController.prototype, "findAllTodayV2", null);
__decorate([
    (0, common_1.Get)('/v2/history'),
    (0, swagger_1.ApiOperation)({ summary: 'Retrieve appointment history for a patient' }),
    (0, swagger_1.ApiQuery)({ name: 'hospital_id', required: true, description: 'ID of the hospital', type: Number }),
    (0, swagger_1.ApiQuery)({ name: 'patient_id', required: true, description: 'ID of the patient', type: Number }),
    (0, swagger_1.ApiQuery)({ name: 'date', required: false, description: 'Date of the appointment', type: String }),
    (0, swagger_1.ApiQuery)({ name: 'doctor', required: false, description: 'ID of the doctor', type: Number }),
    (0, swagger_1.ApiResponse)({ status: 200, description: 'Successfully retrieved appointment history', type: [AppointmentHistoryDto] }),
    (0, swagger_1.ApiResponse)({
        status: 404,
        description: 'Patient charge not found.',
    }),
    (0, swagger_1.ApiResponse)({
        status: 400,
        description: 'Bad request. Validation errors or missing parameters.',
        type: op_hub_appointment_entity_1.ErrorResponse400
    }),
    (0, swagger_1.ApiResponse)({
        status: 500,
        description: 'Internal server error.',
        type: op_hub_appointment_status_controller_1.ErrorResponse500
    }),
    __param(0, (0, common_1.Query)('hospital_id')),
    __param(1, (0, common_1.Query)('patient_id')),
    __param(2, (0, common_1.Query)('date')),
    __param(3, (0, common_1.Query)('doctor')),
    __param(4, (0, common_1.Query)('limit')),
    __param(5, (0, common_1.Query)('page')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Number, Object, Number, String, String]),
    __metadata("design:returntype", Promise)
], OpHubPatientAppointmentListController.prototype, "findAllHistoryV2", null);
__decorate([
    (0, common_1.Get)('/v2/upcoming'),
    (0, swagger_1.ApiOperation)({ summary: 'Retrieve upcoming appointments for a patient' }),
    (0, swagger_1.ApiQuery)({ name: 'hospital_id', required: true, description: 'ID of the hospital', type: Number }),
    (0, swagger_1.ApiQuery)({ name: 'patient_id', required: true, description: 'ID of the patient', type: Number }),
    (0, swagger_1.ApiQuery)({ name: 'date', required: false, description: 'Date for filtering upcoming appointments', type: String }),
    (0, swagger_1.ApiQuery)({ name: 'doctor', required: false, description: 'ID of the doctor', type: Number }),
    (0, swagger_1.ApiResponse)({ status: 200, description: 'Successfully retrieved upcoming appointments', type: [AppointmentHistoryDto] }),
    (0, swagger_1.ApiResponse)({
        status: 404,
        description: 'Patient charge not found.',
    }),
    (0, swagger_1.ApiResponse)({
        status: 400,
        description: 'Bad request. Validation errors or missing parameters.',
        type: op_hub_appointment_entity_1.ErrorResponse400
    }),
    (0, swagger_1.ApiResponse)({
        status: 500,
        description: 'Internal server error.',
        type: op_hub_appointment_status_controller_1.ErrorResponse500
    }),
    __param(0, (0, common_1.Query)('hospital_id')),
    __param(1, (0, common_1.Query)('patient_id')),
    __param(2, (0, common_1.Query)('date')),
    __param(3, (0, common_1.Query)('doctor')),
    __param(4, (0, common_1.Query)('limit')),
    __param(5, (0, common_1.Query)('page')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Number, Object, Number, String, String]),
    __metadata("design:returntype", Promise)
], OpHubPatientAppointmentListController.prototype, "findAllUpcomingV2", null);
exports.OpHubPatientAppointmentListController = OpHubPatientAppointmentListController = __decorate([
    (0, common_1.Controller)('op-hub-patient-appointment-list'),
    __metadata("design:paramtypes", [op_hub_patient_appointment_list_service_1.OpHubPatientAppointmentListService])
], OpHubPatientAppointmentListController);
//# sourceMappingURL=op-hub-patient-appointment-list.controller.js.map