"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.OpHubOverallHeaderSerachService = void 0;
const common_1 = require("@nestjs/common");
const event_emitter_1 = require("@nestjs/event-emitter");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
let OpHubOverallHeaderSerachService = class OpHubOverallHeaderSerachService {
    constructor(dynamicConnection, connection, eventEmitter) {
        this.dynamicConnection = dynamicConnection;
        this.connection = connection;
        this.eventEmitter = eventEmitter;
    }
    async create(createOverallHeaderSearchDto) {
        try {
            let result;
            if (createOverallHeaderSearchDto.module.toUpperCase() == 'PATIENT') {
                const getPatients = await this.dynamicConnection.query(`SELECT patients.*,blood_bank_products.name patient_blood_group FROM patients
        left join blood_bank_products on blood_bank_products.id = patients.blood_bank_product_id WHERE patients.id like ? or patients.patient_name like ? 
        or patients.mobileno like ?`, [
                    '%' + createOverallHeaderSearchDto.search + '%',
                    '%' + createOverallHeaderSearchDto.search + '%',
                    '%' + createOverallHeaderSearchDto.search + '%',
                ]);
                result = getPatients;
            }
            if (createOverallHeaderSearchDto.module.toUpperCase() == 'OPD') {
                const getPatients = await this.dynamicConnection.query(` SELECT
    patients.patient_name,
    patients.id AS patient_id,
            concat("PT",patients.id) plenome_patient_id,
    CONCAT(DATE_FORMAT(appointment.date, '%D %b %Y'), ",", DATE_FORMAT(appointment.time, '%h:%i %p')) AS appointment_date,
    CONCAT(date(appointment.date), " ", time(appointment.time)) AS comp,
    CONCAT( patients.mobileno) AS Mobile,
                coalesce(     GROUP_CONCAT(DISTINCT specialist.specialist_name) ,"-")AS doctorSpecialist,
    patients.dial_code,
    appointment.doctor,
    coalesce(visit_details.case_sheet_document,"-") case_sheet_document,
    CONCAT("Dr. ",staff.name, " ", staff.surname) AS consultant,
    appointment_status.status appointment_status,
    coalesce(visit_details.case_sheet_document) case_sheet_document,
    appointment.appointment_status_id,
    appointment_status.color_code,
    CONCAT("APPN",appointment.id) appointment_id,
    patient_charges.payment_status,
    patient_charges.total apptFees,
    concat("OPDN",opd_details.id) opd_id,
    CASE
        WHEN appointment_queue.position IS NOT NULL THEN appointment_queue.position
        ELSE CONCAT(" ", "- ")
    END AS appointment_token 
  FROM
    appointment
  LEFT JOIN
    patients ON patients.id = appointment.patient_id
  LEFT JOIN
    staff ON staff.id = appointment.doctor
  LEFT JOIN
    appointment_queue ON appointment_queue.appointment_id = appointment.id
    left join 
    appointment_status on appointment_status.id = appointment.appointment_status_id
    LEFT JOIN
    visit_details ON visit_details.id = appointment.visit_details_id
    left join
    opd_details on opd_details.id = visit_details.opd_details_id
    left join 
    patient_charges on patient_charges.id = visit_details.patient_charge_id
                LEFT JOIN specialist ON JSON_CONTAINS(staff.specialist, CAST(specialist.id AS JSON), '$') = 1 WHERE patients.id like ? or patients.patient_name like ? 
              or patients.mobileno like ?  ORDER BY
  appointment.date DESC, appointment.time DESC `, [
                    '%' + createOverallHeaderSearchDto.search + '%',
                    '%' + createOverallHeaderSearchDto.search + '%',
                    '%' + createOverallHeaderSearchDto.search + '%',
                ]);
                result = getPatients;
            }
            if (createOverallHeaderSearchDto.module.toUpperCase() == 'APPOINTMENT') {
                const getPatients = await this.dynamicConnection.query(`SELECT
  patients.patient_name,
  patients.id AS patient_id,
          concat("PT",patients.id) plenome_patient_id,
  CONCAT(DATE_FORMAT(appointment.date, '%D %b %Y'), ",", DATE_FORMAT(appointment.time, '%h:%i %p')) AS appointment_date,
  CONCAT(date(appointment.date), " ", time(appointment.time)) AS comp,
  CONCAT( patients.mobileno) AS Mobile,
              coalesce(     GROUP_CONCAT(DISTINCT specialist.specialist_name) ,"-")AS doctorSpecialist,
  patients.dial_code,
  opd_details.id opd_id,
  appointment.doctor,
  CONCAT("Dr. ",staff.name, " ", staff.surname) AS consultant,
  appointment_status.status appointment_status,
  appointment.appointment_status_id,
  appointment_status.color_code,
  CONCAT("APPN",appointment.id) appointment_id,
  patient_charges.payment_status,
  patient_charges.total apptFees,
  CASE
      WHEN appointment_queue.position IS NOT NULL THEN appointment_queue.position
      ELSE CONCAT(" ", "- ")
  END AS appointment_token 
FROM
  appointment
LEFT JOIN
  patients ON patients.id = appointment.patient_id
LEFT JOIN
  staff ON staff.id = appointment.doctor
LEFT JOIN
  appointment_queue ON appointment_queue.appointment_id = appointment.id
  left join 
  appointment_status on appointment_status.id = appointment.appointment_status_id
  LEFT JOIN
  visit_details ON visit_details.id = appointment.visit_details_id
  left join opd_details on opd_details.id = visit_details.opd_details_id
  left join patient_charges on patient_charges.id = visit_details.patient_charge_id
              LEFT JOIN specialist ON JSON_CONTAINS(staff.specialist, CAST(specialist.id AS JSON), '$') = 1
                WHERE patients.id like ? or patients.patient_name like ? 
              or patients.mobileno like ? 
              GROUP BY
    patients.patient_name, 
    patients.id, 
    appointment.date, 
    appointment.time, 
    patients.mobileno, 
    patients.dial_code, 
    appointment.doctor, 
    staff.name, 
    staff.surname, 
    appointment_status.status, 
    appointment.appointment_status_id, 
    appointment_status.color_code, 
    appointment.id, 
    apptFees,
    opd_id,
    patient_charges.payment_status, 
    appointment_queue.position 
    ORDER BY
  date(appointment.date) ASC, time(appointment.date) ASC `, [
                    '%' + createOverallHeaderSearchDto.search + '%',
                    '%' + createOverallHeaderSearchDto.search + '%',
                    '%' + createOverallHeaderSearchDto.search + '%',
                ]);
                result = getPatients;
            }
            return {
                status: 'success',
                message: 'details found successfully',
                details: result,
            };
        }
        catch (error) {
            return error;
        }
    }
};
exports.OpHubOverallHeaderSerachService = OpHubOverallHeaderSerachService;
exports.OpHubOverallHeaderSerachService = OpHubOverallHeaderSerachService = __decorate([
    (0, common_1.Injectable)(),
    __param(1, (0, typeorm_1.InjectDataSource)('AdminConnection')),
    __metadata("design:paramtypes", [typeorm_2.DataSource,
        typeorm_2.DataSource,
        event_emitter_1.EventEmitter2])
], OpHubOverallHeaderSerachService);
//# sourceMappingURL=op-hub-overall-header-serach.service.js.map