"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.OpHubOpdPrescriptionController = void 0;
const common_1 = require("@nestjs/common");
const op_hub_opd_prescription_service_1 = require("./op-hub-opd-prescription.service");
const swagger_1 = require("@nestjs/swagger");
const update_opd_prescription_dto_1 = require("./dto/update-opd-prescription.dto");
const op_hub_opd_prescription_entity_1 = require("./entities/op-hub-opd-prescription.entity");
let OpHubOpdPrescriptionController = class OpHubOpdPrescriptionController {
    constructor(opdPrescriptionService) {
        this.opdPrescriptionService = opdPrescriptionService;
    }
    async create(createOpdPrescriptionDto) {
        return this.opdPrescriptionService.create(createOpdPrescriptionDto);
    }
    findAll(opd_id, hospital_id) {
        return this.opdPrescriptionService.findAll(opd_id, hospital_id);
    }
    update(updateOpdPrescriptionDto) {
        return this.opdPrescriptionService.update(updateOpdPrescriptionDto);
    }
    remove(id, hospital_id) {
        return this.opdPrescriptionService.remove(+id, hospital_id);
    }
};
exports.OpHubOpdPrescriptionController = OpHubOpdPrescriptionController;
__decorate([
    (0, common_1.Post)(),
    (0, swagger_1.ApiOperation)({ summary: 'Create a new OPD prescription' }),
    (0, swagger_1.ApiResponse)({ status: 201, description: 'The prescription has been successfully created.' }),
    (0, swagger_1.ApiResponse)({ status: 400, description: 'Invalid input' }),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], OpHubOpdPrescriptionController.prototype, "create", null);
__decorate([
    (0, common_1.Get)(),
    (0, swagger_1.ApiQuery)({ name: 'opd_id', required: true, type: Number, description: 'opd_id of the appointment' }),
    (0, swagger_1.ApiQuery)({ name: 'hospital_id', required: true, type: Number, description: 'ID of the hospital' }),
    (0, swagger_1.ApiOperation)({ summary: 'Retrieve all OPD prescriptions' }),
    (0, swagger_1.ApiResponse)({ status: 200, description: 'List of prescriptions', isArray: true, type: op_hub_opd_prescription_entity_1.PrescriptionFetchResponseDto }),
    __param(0, (0, common_1.Query)('opd_id')),
    __param(1, (0, common_1.Query)('hospital_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object]),
    __metadata("design:returntype", void 0)
], OpHubOpdPrescriptionController.prototype, "findAll", null);
__decorate([
    (0, common_1.Patch)(),
    (0, swagger_1.ApiOperation)({ summary: 'Update an existing OPD prescription' }),
    (0, swagger_1.ApiResponse)({ status: 200, description: 'The prescription has been successfully updated.' }),
    (0, swagger_1.ApiResponse)({ status: 404, description: 'Prescription not found' }),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [update_opd_prescription_dto_1.UpdateOpdPrescriptionDto]),
    __metadata("design:returntype", void 0)
], OpHubOpdPrescriptionController.prototype, "update", null);
__decorate([
    (0, common_1.Delete)(),
    (0, swagger_1.ApiOperation)({ summary: 'Delete an OPD prescription' }),
    (0, swagger_1.ApiQuery)({ name: 'id', required: true, type: Number, description: 'id of the past treatment history' }),
    (0, swagger_1.ApiQuery)({ name: 'hospital_id', required: true, type: Number, description: 'ID of the hospital' }),
    (0, swagger_1.ApiResponse)({ status: 200, description: 'The prescription has been successfully deleted.' }),
    (0, swagger_1.ApiResponse)({ status: 404, description: 'Prescription not found' }),
    __param(0, (0, common_1.Query)('id')),
    __param(1, (0, common_1.Query)('hospital_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object]),
    __metadata("design:returntype", void 0)
], OpHubOpdPrescriptionController.prototype, "remove", null);
exports.OpHubOpdPrescriptionController = OpHubOpdPrescriptionController = __decorate([
    (0, common_1.Controller)('op-hub-opd-prescription'),
    __metadata("design:paramtypes", [op_hub_opd_prescription_service_1.OpHubOpdPrescriptionService])
], OpHubOpdPrescriptionController);
//# sourceMappingURL=op-hub-opd-prescription.controller.js.map