"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.UpdateOpdPrescriptionDto = exports.FilledUsingEnum = void 0;
const swagger_1 = require("@nestjs/swagger");
const class_validator_1 = require("class-validator");
var FilledUsingEnum;
(function (FilledUsingEnum) {
    FilledUsingEnum["Voice"] = "voice";
    FilledUsingEnum["Scribble"] = "scribble";
    FilledUsingEnum["Text"] = "text";
})(FilledUsingEnum || (exports.FilledUsingEnum = FilledUsingEnum = {}));
class UpdateOpdPrescriptionDto {
}
exports.UpdateOpdPrescriptionDto = UpdateOpdPrescriptionDto;
__decorate([
    (0, swagger_1.ApiProperty)({ example: 1, description: 'Unique identifier for the prescription' }),
    __metadata("design:type", Number)
], UpdateOpdPrescriptionDto.prototype, "id", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 'Paracetamol', description: 'Name of the medicine' }),
    __metadata("design:type", String)
], UpdateOpdPrescriptionDto.prototype, "medicine_name", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: '1-1-1-1', description: 'Frequency of the medicine' }),
    __metadata("design:type", String)
], UpdateOpdPrescriptionDto.prototype, "frequency", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: '500mg', description: 'Dosage of the medicine' }),
    __metadata("design:type", String)
], UpdateOpdPrescriptionDto.prototype, "dosage", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: '5', description: 'Duration count of the treatment' }),
    __metadata("design:type", String)
], UpdateOpdPrescriptionDto.prototype, "duration_count", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 'days', description: 'Duration limit (e.g., days, weeks)' }),
    __metadata("design:type", String)
], UpdateOpdPrescriptionDto.prototype, "duration_limit", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: '10', description: 'Quantity of the medicine', required: false }),
    __metadata("design:type", String)
], UpdateOpdPrescriptionDto.prototype, "quantity", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 'before meal', description: 'When to take the medicine', required: false }),
    __metadata("design:type", String)
], UpdateOpdPrescriptionDto.prototype, "when", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 'Take with water', description: 'Remarks or additional instructions', required: false }),
    __metadata("design:type", String)
], UpdateOpdPrescriptionDto.prototype, "remarks", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 'voice', description: 'Method used to fill the prescription', enum: FilledUsingEnum }),
    (0, class_validator_1.IsEnum)(FilledUsingEnum, { message: 'filled_using must be one of: voice, scribble, text' }),
    __metadata("design:type", String)
], UpdateOpdPrescriptionDto.prototype, "filled_using", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 1, description: 'Hospital ID where the prescription was created' }),
    __metadata("design:type", Number)
], UpdateOpdPrescriptionDto.prototype, "hospital_id", void 0);
//# sourceMappingURL=update-opd-prescription.dto.js.map