"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.OpHubManualVitalsService = void 0;
const common_1 = require("@nestjs/common");
const event_emitter_1 = require("@nestjs/event-emitter");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
let OpHubManualVitalsService = class OpHubManualVitalsService {
    constructor(dynamicConnection, connection, eventEmitter) {
        this.dynamicConnection = dynamicConnection;
        this.connection = connection;
        this.eventEmitter = eventEmitter;
    }
    async create(createManualVitalDto, opd_id, hospital_id) {
        if (!hospital_id) {
            return {
                "status": "failed",
                "messege": "enter hospital_id to post clinical notes"
            };
        }
        try {
            await this.dynamicConnection.query(`update visit_details set spo2 = ?,
            respiration = ?,
            temperature = ?,
            pulse = ?,
            weight = ?,
            height = ?,
            bp = ? where opd_details_id = ?`, [
                createManualVitalDto.spo2,
                createManualVitalDto.respiration,
                createManualVitalDto.temperature,
                createManualVitalDto.pulse,
                createManualVitalDto.weight,
                createManualVitalDto.height,
                createManualVitalDto.bp,
                opd_id
            ]);
            const [getAdminOPD] = await this.connection.query(`select id from opd_details where Hospital_id = ? and hos_opd_id = ?`, [
                hospital_id,
                opd_id
            ]);
            await this.connection.query(`update visit_details set spo2 = ?,
              respiration = ?,
              temperature = ?,
              pulse = ?,
              weight = ?,
              height = ?,
              bp = ? where opd_details_id = ?`, [
                createManualVitalDto.spo2,
                createManualVitalDto.respiration,
                createManualVitalDto.temperature,
                createManualVitalDto.pulse,
                createManualVitalDto.weight,
                createManualVitalDto.height,
                createManualVitalDto.bp,
                getAdminOPD.id
            ]);
            return {
                "status": "success",
                "message": "manual vitals updated successfully"
            };
        }
        catch (error) {
            return {
                "status": "failed",
                "message": "unable to update manual vital values"
            };
        }
    }
    async findAll(opd_id, hospital_id) {
        if (!hospital_id) {
            return {
                "status": "failed",
                "messege": "enter hospital_id to post clinical notes"
            };
        }
        try {
            const [getManualVitals] = await this.dynamicConnection.query(`select  
            concat("OPDN",opd_details_id) opd_details_id,
            opd_details.patient_id,
            concat("Dr.",staff.name," ",staff.surname) consultant,
            CONCAT(DATE_FORMAT(visit_details.appointment_date, '%D %b %Y')) AS date_time,

            coalesce(visit_details.spo2,"") spo2,
    coalesce(visit_details.respiration,"") respiration,
    coalesce(visit_details.temperature,"") temperature,
    coalesce(visit_details.pulse,"") pulse,
    coalesce(visit_details.weight,"") weight,
   coalesce(visit_details.height,"")height,
    coalesce(visit_details.bp,"")bp from visit_details left join staff on staff.id = visit_details.cons_doctor 
    left join opd_details on opd_details.id  = visit_details.opd_details_id
    where opd_details_id = ?`, [opd_id]);
            return {
                "status": "success",
                "message": "manual vitals fetched successfully",
                "details": getManualVitals
            };
        }
        catch (error) {
            console.log(error);
            return {
                "status": "failed",
                "message": "unable to fetch manual vitals"
            };
        }
    }
};
exports.OpHubManualVitalsService = OpHubManualVitalsService;
exports.OpHubManualVitalsService = OpHubManualVitalsService = __decorate([
    (0, common_1.Injectable)(),
    __param(1, (0, typeorm_1.InjectDataSource)('AdminConnection')),
    __metadata("design:paramtypes", [typeorm_2.DataSource,
        typeorm_2.DataSource,
        event_emitter_1.EventEmitter2])
], OpHubManualVitalsService);
//# sourceMappingURL=op-hub-manual-vitals.service.js.map