"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.OpHubManualVitalsController = void 0;
const common_1 = require("@nestjs/common");
const op_hub_manual_vitals_service_1 = require("./op-hub-manual-vitals.service");
const swagger_1 = require("@nestjs/swagger");
const create_manual_vital_dto_1 = require("./dto/create-manual_vital.dto");
const op_hub_manual_vital_entity_1 = require("./entities/op-hub-manual-vital.entity");
let OpHubManualVitalsController = class OpHubManualVitalsController {
    constructor(manualVitalsService) {
        this.manualVitalsService = manualVitalsService;
    }
    create(createManualVitalDto, opd_id, hospital_id) {
        return this.manualVitalsService.create(createManualVitalDto, opd_id, hospital_id);
    }
    findAll(opd_id, hospital_id) {
        return this.manualVitalsService.findAll(opd_id, hospital_id);
    }
};
exports.OpHubManualVitalsController = OpHubManualVitalsController;
__decorate([
    (0, common_1.Post)(),
    (0, swagger_1.ApiOperation)({ summary: 'Create manual vitals entry' }),
    (0, swagger_1.ApiResponse)({ status: 201, description: 'Manual vitals entry created successfully.' }),
    (0, swagger_1.ApiResponse)({ status: 400, description: 'Invalid input or validation error.' }),
    (0, swagger_1.ApiQuery)({ name: 'opd_id', required: true, type: String, description: 'OPD ID associated with the vitals' }),
    (0, swagger_1.ApiQuery)({ name: 'hospital_id', required: true, type: String, description: 'Hospital ID associated with the vitals' }),
    (0, swagger_1.ApiBody)({ type: create_manual_vital_dto_1.CreateManualVitalDto, description: 'Vitals data' }),
    __param(0, (0, common_1.Body)()),
    __param(1, (0, common_1.Query)('opd_id')),
    __param(2, (0, common_1.Query)('hospital_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [create_manual_vital_dto_1.CreateManualVitalDto, String, String]),
    __metadata("design:returntype", void 0)
], OpHubManualVitalsController.prototype, "create", null);
__decorate([
    (0, common_1.Get)(),
    (0, swagger_1.ApiOperation)({ summary: 'Retrieve all manual vitals entries' }),
    (0, swagger_1.ApiQuery)({ name: 'opd_id', required: true, type: String, description: 'OPD ID associated with the vitals' }),
    (0, swagger_1.ApiQuery)({ name: 'hospital_id', required: true, type: String, description: 'Hospital ID associated with the vitals' }),
    (0, swagger_1.ApiResponse)({ status: 200, description: 'List of manual vitals entries fetched successfully.', type: op_hub_manual_vital_entity_1.getManualVital }),
    (0, swagger_1.ApiResponse)({ status: 404, description: 'No manual vitals entries found.' }),
    __param(0, (0, common_1.Query)('opd_id')),
    __param(1, (0, common_1.Query)('hospital_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, String]),
    __metadata("design:returntype", void 0)
], OpHubManualVitalsController.prototype, "findAll", null);
exports.OpHubManualVitalsController = OpHubManualVitalsController = __decorate([
    (0, common_1.Controller)('op-hub-manual-vitals'),
    __metadata("design:paramtypes", [op_hub_manual_vitals_service_1.OpHubManualVitalsService])
], OpHubManualVitalsController);
//# sourceMappingURL=op-hub-manual-vitals.controller.js.map