"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.OpHubLoginService = void 0;
const common_1 = require("@nestjs/common");
const event_emitter_1 = require("@nestjs/event-emitter");
const typeorm_1 = require("@nestjs/typeorm");
const axios_1 = require("axios");
const typeorm_2 = require("typeorm");
const crypto = require('node:crypto');
let OpHubLoginService = class OpHubLoginService {
    constructor(dynamicConnection, connection, eventEmitter) {
        this.dynamicConnection = dynamicConnection;
        this.connection = connection;
        this.eventEmitter = eventEmitter;
    }
    generateRandomPassword(length = 12) {
        const characters = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789!@#$%^&*()-_=+';
        const randomBytes = crypto.randomBytes(length);
        let password = '';
        for (let i = 0; i < length; i++) {
            const randomIndex = randomBytes[i] % characters.length;
            password += characters.charAt(randomIndex);
        }
        return password;
    }
    async create(Entity) {
        const [getHospital_id] = await this.connection.query(`select hospital_id,staff_id,is_reset_needed from hospital_staffs 
  where username = ? and password = ?`, [Entity.Username, Entity.Password]);
        if (getHospital_id) {
            const [getHosName] = await this.connection.query(`select * from hospitals where plenome_id = ?`, [getHospital_id.hospital_id]);
            const [getAdminStaffEmail] = await this.connection.query(`select email from staff where id = ?`, [getHospital_id.staff_id]);
            try {
                const [getHospitalStaff_id] = await this.dynamicConnection.query(`select staff.id id,roles.id role_id,roles.name,staff.is_active,
concat(staff.name," ",staff.surname) staffName,staff.image,staff.employee_id
from staff
left join staff_roles on staff.id = staff_roles.staff_id
left join roles on roles.id = staff_roles.role_id
where BINARY staff.email = ? and BINARY staff.password = ?`, [getAdminStaffEmail.email, Entity.Password]);
                let server = process.env.server;
                if (getHospitalStaff_id.is_active == 1) {
                    let resp = {
                        Hospital_id: getHospital_id.hospital_id,
                        hip_id: getHosName.hip_id,
                        Hospital_name: getHosName.hospital_name,
                        Hospital_address: getHosName.address,
                        Hospital_logo: getHosName.logo,
                        Hospital_image: getHosName.image,
                        Staff_id: getHospitalStaff_id.id,
                        staffImage: getHospitalStaff_id.image,
                        username: Entity.Username,
                        password: Entity.Password,
                        role_id: getHospitalStaff_id.role_id,
                        staffName: getHospitalStaff_id.staffName,
                        role_name: getHospitalStaff_id.name,
                        resetStatus: getHospital_id.is_reset_needed,
                        employeeID: getHospitalStaff_id.employee_id,
                        abha_scan_qr: `https://phrsbx.abdm.gov.in/share-profile?hip-id=${getHosName.hip_id}&counter-id=${server}-0`,
                    };
                    if (getHospitalStaff_id.role_id == 3) {
                        resp.abha_scan_qr = `https://phrsbx.abdm.gov.in/share-profile?hip-id=${getHosName.hip_id}&counter-id=${server}-${getHospitalStaff_id.employee_id}`;
                    }
                    return {
                        status: 'success',
                        messege: 'Password verified successfully',
                        details: resp,
                    };
                }
                else {
                    return {
                        status: 'failed',
                        message: 'Contact admin as you are disabled',
                    };
                }
            }
            catch (error) {
                return error;
            }
        }
        else {
            return {
                status: 'failed',
                message: 'Enter Correct username and password',
            };
        }
    }
    async ForgetPassword(Entity) {
        const [getHospital_id] = await this.connection.query(`select hospital_id,staff_id,id from hospital_staffs 
where username = ?`, [Entity.Username]);
        if (getHospital_id) {
            const [getHosName] = await this.connection.query(`select hospital_name
   from hospitals 
  where hospitals.plenome_id = ?`, [getHospital_id.hospital_id]);
            const [getAdminStaffEmail] = await this.connection.query(`select email,staff.name,staff.surname from staff
   where id = ?`, [getHospital_id.staff_id]);
            try {
                const [getHospitalStaff_id] = await this.dynamicConnection.query(`select id from staff where email = ? `, [getAdminStaffEmail.email]);
                const Password = this.generateRandomPassword();
                await this.connection.query(`update hospital_staffs set
password = ?,is_reset_needed = ? where id = ? `, [Password, 1, getHospital_id.id]);
                await this.dynamicConnection.query(`update staff set password  = ? where id = ?`, [Password, getHospitalStaff_id.id]);
                const EmailData = {
                    email: getAdminStaffEmail.email,
                    name: getAdminStaffEmail.name + ' ' + getAdminStaffEmail.surname,
                    HosName: getHosName.hospital_name,
                    Password: Password,
                };
                await axios_1.default.post(`https://notifications.plenome.com//send-email`, EmailData);
                return {
                    status: 'success',
                    messege: 'Password sent successfully to your Email',
                };
            }
            catch (error) {
                return error;
            }
        }
        else {
            return {
                status: 'failed',
                message: 'Enter Correct username or contact your Admin',
            };
        }
    }
    async ResetPassword(Entity) {
        const [getHospital_id] = await this.connection.query(`select hospital_id,staff_id,id,is_reset_needed from hospital_staffs 
where username = ?`, [Entity.Username]);
        if (getHospital_id) {
            if (getHospital_id.is_reset_needed == 1) {
                const [getAdminStaffEmail] = await this.connection.query(`select email from staff where id = ?`, [getHospital_id.staff_id]);
                try {
                    const [getHospitalStaff_id] = await this.dynamicConnection.query(`select id from staff where email = ? `, [getAdminStaffEmail.email]);
                    const Password = Entity.Password;
                    await this.connection.query(`update hospital_staffs set password = ?,is_reset_needed = ? where id = ? `, [Password, 0, getHospital_id.id]);
                    await this.dynamicConnection.query(`update staff set password  = ? where id = ?`, [Password, getHospitalStaff_id.id]);
                    return {
                        status: 'success',
                        messege: 'Password Changed successfully.',
                    };
                }
                catch (error) {
                    return error;
                }
            }
            else {
                return {
                    status: 'failed',
                    message: 'cannot change the password as no request is made for change of password',
                };
            }
        }
        else {
            return {
                status: 'failed',
                message: 'contact admin to register as staff',
            };
        }
    }
    async getHosDetails(hospital_id) {
        try {
            const [getHosName] = await this.connection.query(`select * from hospitals where plenome_id = ?`, [hospital_id]);
            const [getheadfoot] = await this.dynamicConnection.query(`select print_header, print_footer from print_setting where setting_for = 'opdpre'`);
            const resp = {
                Hospital_id: hospital_id,
                Hospital_name: getHosName.hospital_name ?? '',
                Hospital_address: getHosName.address ?? '',
                Hospital_state: getHosName.state ?? '',
                Hospital_district: getHosName.district ?? '',
                Hospital_pincode: getHosName.pincode ?? '',
                Hospital_logo: getHosName.logo ?? '',
                Hospital_image: getHosName.image ?? '',
                Hospital_website_link: getHosName.website ?? '',
                Header: getheadfoot.print_header ?? '',
                Footer: getheadfoot.print_footer ?? '',
                Hospital_contact_no: getHosName.contact_no ?? '',
            };
            return {
                status: 'success',
                message: 'hospital details fetched successfully',
                details: resp,
            };
        }
        catch (error) {
            return {
                status: 'failed',
                message: 'unable to fetch hospital details',
                error: error,
            };
        }
    }
};
exports.OpHubLoginService = OpHubLoginService;
exports.OpHubLoginService = OpHubLoginService = __decorate([
    (0, common_1.Injectable)(),
    __param(1, (0, typeorm_1.InjectDataSource)('AdminConnection')),
    __metadata("design:paramtypes", [typeorm_2.DataSource,
        typeorm_2.DataSource,
        event_emitter_1.EventEmitter2])
], OpHubLoginService);
//# sourceMappingURL=op-hub-login.service.js.map