import { EventEmitter2 } from '@nestjs/event-emitter';
import { DataSource } from 'typeorm';
import { Login } from './entities/op-hub-login.entity';
export declare class OpHubLoginService {
    private readonly dynamicConnection;
    private readonly connection;
    private readonly eventEmitter;
    constructor(dynamicConnection: DataSource, connection: DataSource, eventEmitter: EventEmitter2);
    generateRandomPassword(length?: number): string;
    create(Entity: Login): Promise<any>;
    ForgetPassword(Entity: Login): Promise<any>;
    ResetPassword(Entity: Login): Promise<any>;
    getHosDetails(hospital_id: number): Promise<{
        status: string;
        message: string;
        details: {
            Hospital_id: number;
            Hospital_name: any;
            Hospital_address: any;
            Hospital_state: any;
            Hospital_district: any;
            Hospital_pincode: any;
            Hospital_logo: any;
            Hospital_image: any;
            Hospital_website_link: any;
            Header: any;
            Footer: any;
            Hospital_contact_no: any;
        };
        error?: undefined;
    } | {
        status: string;
        message: string;
        error: any;
        details?: undefined;
    }>;
}
