"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.OpHubLoginController = exports.ErrorResponse = exports.SuccessResponse = void 0;
const common_1 = require("@nestjs/common");
const op_hub_login_service_1 = require("./op-hub-login.service");
const swagger_1 = require("@nestjs/swagger");
const op_hub_login_entity_1 = require("./entities/op-hub-login.entity");
class SuccessResponse {
}
exports.SuccessResponse = SuccessResponse;
__decorate([
    (0, swagger_1.ApiProperty)({ example: 'success', description: 'The status of the response' }),
    __metadata("design:type", String)
], SuccessResponse.prototype, "status", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 'Password verified successfully', description: 'Message providing additional context' }),
    __metadata("design:type", String)
], SuccessResponse.prototype, "message", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        type: Object,
        description: 'Details about the authenticated staff member',
    }),
    __metadata("design:type", Object)
], SuccessResponse.prototype, "details", void 0);
class ErrorResponse {
}
exports.ErrorResponse = ErrorResponse;
__decorate([
    (0, swagger_1.ApiProperty)({ example: 'failed', description: 'The status of the response' }),
    __metadata("design:type", String)
], ErrorResponse.prototype, "status", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 'Enter Correct username and password', description: 'Error message' }),
    __metadata("design:type", String)
], ErrorResponse.prototype, "message", void 0);
let OpHubLoginController = class OpHubLoginController {
    constructor(loginService) {
        this.loginService = loginService;
    }
    async create(Entity, res) {
        const result = await this.loginService.create(Entity);
        if (result.status == "success") {
            return res.status(201).json(result);
        }
        else {
            return res.status(401).json(result);
        }
    }
    async ForgotPassword(Entity, res) {
        const result = await this.loginService.ForgetPassword(Entity);
        if (result.status == "success") {
            return res.status(201).json(result);
        }
        else {
            return res.status(401).json(result);
        }
    }
    async resetPassword(Entity, res) {
        const result = await this.loginService.ResetPassword(Entity);
        if (result.status == "success") {
            return res.status(201).json(result);
        }
        else {
            return res.status(401).json(result);
        }
    }
    async getHosDetails(hospital_id) {
        if (!hospital_id) {
            return {
                "status": "failed",
                "message": "enter hospital_id to get hospital details"
            };
        }
        return await this.loginService.getHosDetails(hospital_id);
    }
};
exports.OpHubLoginController = OpHubLoginController;
__decorate([
    (0, common_1.Post)(),
    (0, swagger_1.ApiOperation)({ summary: 'User login' }),
    (0, swagger_1.ApiResponse)({ status: 201, type: SuccessResponse, description: 'Login successful' }),
    (0, swagger_1.ApiResponse)({ status: 401, type: ErrorResponse, description: 'Unauthorized' }),
    __param(0, (0, common_1.Body)()),
    __param(1, (0, common_1.Res)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [op_hub_login_entity_1.Login, Object]),
    __metadata("design:returntype", Promise)
], OpHubLoginController.prototype, "create", null);
__decorate([
    (0, common_1.Post)('/forgotPassword'),
    __param(0, (0, common_1.Body)()),
    __param(1, (0, common_1.Res)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [op_hub_login_entity_1.Login, Object]),
    __metadata("design:returntype", Promise)
], OpHubLoginController.prototype, "ForgotPassword", null);
__decorate([
    (0, common_1.Post)('/resetPassword'),
    __param(0, (0, common_1.Body)()),
    __param(1, (0, common_1.Res)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [op_hub_login_entity_1.Login, Object]),
    __metadata("design:returntype", Promise)
], OpHubLoginController.prototype, "resetPassword", null);
__decorate([
    (0, common_1.Post)('/getHosDetails'),
    __param(0, (0, common_1.Query)('hospital_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number]),
    __metadata("design:returntype", Promise)
], OpHubLoginController.prototype, "getHosDetails", null);
exports.OpHubLoginController = OpHubLoginController = __decorate([
    (0, common_1.Controller)('op-hub-login'),
    __metadata("design:paramtypes", [op_hub_login_service_1.OpHubLoginService])
], OpHubLoginController);
//# sourceMappingURL=op-hub-login.controller.js.map