import { OpHubLoginService } from './op-hub-login.service';
import { Login } from './entities/op-hub-login.entity';
import { Response } from 'express';
export declare class SuccessResponse {
    status: string;
    message: string;
    details: {
        Hospital_id: number;
        Hospital_name: string;
        Hospital_address: string;
        Staff_id: number;
        staffImage: string;
        username: string;
        password: string;
        role_id: number;
        staffName: string;
        role_name: string;
        resetStatus: number;
    };
}
export declare class ErrorResponse {
    status: string;
    message: string;
}
export declare class OpHubLoginController {
    private readonly loginService;
    constructor(loginService: OpHubLoginService);
    create(Entity: Login, res: Response): Promise<Response<any, Record<string, any>>>;
    ForgotPassword(Entity: Login, res: Response): Promise<Response<any, Record<string, any>>>;
    resetPassword(Entity: Login, res: Response): Promise<Response<any, Record<string, any>>>;
    getHosDetails(hospital_id: number): Promise<{
        status: string;
        message: string;
        details: {
            Hospital_id: number;
            Hospital_name: any;
            Hospital_address: any;
            Hospital_state: any;
            Hospital_district: any;
            Hospital_pincode: any;
            Hospital_logo: any;
            Hospital_image: any;
            Hospital_website_link: any;
            Header: any;
            Footer: any;
            Hospital_contact_no: any;
        };
        error?: undefined;
    } | {
        status: string;
        message: string;
        error: any;
        details?: undefined;
    } | {
        status: string;
        message: string;
    }>;
}
