"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.OpHubInternalAppntDoctorsController = exports.DoctorDto = void 0;
const common_1 = require("@nestjs/common");
const op_hub_internal_appnt_doctors_service_1 = require("./op-hub-internal-appnt-doctors.service");
const swagger_1 = require("@nestjs/swagger");
const op_hub_appointment_status_controller_1 = require("../op-hub-appointment-status/op-hub-appointment-status.controller");
const op_hub_appointment_entity_1 = require("../op-hub-appointment/entities/op-hub-appointment.entity");
class DoctorDto {
}
exports.DoctorDto = DoctorDto;
__decorate([
    (0, swagger_1.ApiProperty)({ example: 98, description: 'ID of the doctor' }),
    __metadata("design:type", Number)
], DoctorDto.prototype, "doctorId", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 'Dr. Matheshwari N', description: 'Name of the doctor' }),
    __metadata("design:type", String)
], DoctorDto.prototype, "doctorName", void 0);
let OpHubInternalAppntDoctorsController = class OpHubInternalAppntDoctorsController {
    constructor(internalAppntDoctorsService) {
        this.internalAppntDoctorsService = internalAppntDoctorsService;
    }
    findAll(hospital_id) {
        return this.internalAppntDoctorsService.findAll(hospital_id);
    }
};
exports.OpHubInternalAppntDoctorsController = OpHubInternalAppntDoctorsController;
__decorate([
    (0, common_1.Get)(),
    (0, swagger_1.ApiOperation)({ summary: 'Retrieve all doctors' }),
    (0, swagger_1.ApiQuery)({
        name: 'hospital_id',
        required: true,
        description: 'The ID of the hospital to filter the doctors',
        example: 1,
    }),
    (0, swagger_1.ApiResponse)({
        status: 200,
        description: 'List of doctors retrieved successfully.',
        type: [DoctorDto],
    }),
    (0, swagger_1.ApiResponse)({
        status: 500,
        description: 'Internal server error',
        type: op_hub_appointment_status_controller_1.ErrorResponse500,
    }),
    (0, swagger_1.ApiResponse)({
        status: 400,
        description: 'Internal server error',
        type: op_hub_appointment_entity_1.ErrorResponse400,
    }),
    __param(0, (0, common_1.Query)('hospital_id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number]),
    __metadata("design:returntype", void 0)
], OpHubInternalAppntDoctorsController.prototype, "findAll", null);
exports.OpHubInternalAppntDoctorsController = OpHubInternalAppntDoctorsController = __decorate([
    (0, common_1.Controller)('op-hub-internal-appnt-doctors'),
    __metadata("design:paramtypes", [op_hub_internal_appnt_doctors_service_1.OpHubInternalAppntDoctorsService])
], OpHubInternalAppntDoctorsController);
//# sourceMappingURL=op-hub-internal-appnt-doctors.controller.js.map