"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.OpHubGetAbhaAddressOfPatientService = void 0;
const common_1 = require("@nestjs/common");
const event_emitter_1 = require("@nestjs/event-emitter");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
let OpHubGetAbhaAddressOfPatientService = class OpHubGetAbhaAddressOfPatientService {
    constructor(dynamicConnection, connection, eventEmitter) {
        this.dynamicConnection = dynamicConnection;
        this.connection = connection;
        this.eventEmitter = eventEmitter;
    }
    async findAll(patient_id) {
        try {
            const getAbhaAddress = await this.dynamicConnection.query(`SELECT abhaAddress
FROM patient_abha_address
WHERE patient_id = ?
ORDER BY created_at DESC
LIMIT 1`, [patient_id]);
            if (getAbhaAddress.length > 0) {
                return {
                    status: 'success',
                    message: 'patient abha address found successfully',
                    abha_address: getAbhaAddress[0],
                };
            }
            else {
                return {
                    status: 'success',
                    message: 'no abha address found for the patient',
                };
            }
        }
        catch (error) {
            return {
                status: 'failed',
                message: 'patient abha address not found',
                abha_address: error,
            };
        }
    }
};
exports.OpHubGetAbhaAddressOfPatientService = OpHubGetAbhaAddressOfPatientService;
exports.OpHubGetAbhaAddressOfPatientService = OpHubGetAbhaAddressOfPatientService = __decorate([
    (0, common_1.Injectable)(),
    __param(1, (0, typeorm_1.InjectDataSource)('AdminConnection')),
    __metadata("design:paramtypes", [typeorm_2.DataSource,
        typeorm_2.DataSource,
        event_emitter_1.EventEmitter2])
], OpHubGetAbhaAddressOfPatientService);
//# sourceMappingURL=op-hub-get-abha-address-of-patient.service.js.map